/* $Id: Visit.h,v 1.3 1991/12/18 16:02:28 cogito Exp $ */

/*======================================================================*
 *									*
 *	FILE:		Visit/Visit.h					*
 *									*
 *	CONTENTS:	Shared Header-File of the directory Visit	*
 *									*
 *	AUTHOR:		Volker Niepel					*
 *									*
 *======================================================================*/


typedef struct {
	PRODENTRY	*prod;
	VSPTR		elem, last;
	int		no;
} tVisitElemSelection;


#define IS_LEAVE(elem)	((elem)->vscls == VSVISIT && \
			 (elem)->vsinfo.visit.vssno == 0)
#define IS_VISIT(elem)	((elem)->vscls == VSVISIT && \
			 (elem)->vsinfo.visit.vssno != 0)


/************************************************************************
 *			      VisitCreate.c				*
 ************************************************************************/

EXTERN void VisitCreateNew();
	/* int	pid;	*/

EXTERN void VisitCloseCB();
	/* Callback	*/

EXTERN void VisitCloseAllCB();
	/* Callback	*/


/************************************************************************
 *			       VisitDraw.c				*
 ************************************************************************/

EXTERN void VisitComputeSize();
	/* PRODENTRY	*prod;		*/

EXTERN void VisitComputeWindowSize();
	/* PRODENTRY	*prod;		*/
	/* Dimension	*width_return;	*/
	/* Dimension	*height_return;	*/

EXTERN void VisitResizeCB();
	/* Callback			*/

EXTERN void VisitRedrawCB();
	/* Callback			*/


/************************************************************************
 *			       VisitLife.c				*
 ************************************************************************/

EXTERN void VisitUpdateProdLifes();
	/* PRODENTRY	*prod;		*/

EXTERN void VisitComputeLifetimes();

EXTERN void VisitUnmarkLifetimeCB();
	/* Callback			*/

EXTERN void VisitMarkLifetime();
	/* SYMBENTRY	*symb;		*/
	/* ATTRENTRY	*ae;		*/

EXTERN void VisitDrawLifes();
	/* Window	win;		*/
	/* Region	reg;		*/
	/* PRODENTRY	*prod;		*/


/************************************************************************
 *			       VisitMenu.c				*
 ************************************************************************/

EXTERN void VisitCreateMenu();
	/* Widget	father;		*/


/************************************************************************
 *			      VisitSelect.c				*
 ************************************************************************/

EXTERN tVisitElemSelection VisitSelection, VisitMarkedElem;
EXTERN VSPTR MoveRangeStartElem, MoveRangeEndElem;

EXTERN void VisitSelectCB();
	/* Callback	*/


/************************************************************************
 *			       VisitUtil.c				*
 ************************************************************************/

EXTERN SLNODE *SymbnoToNode();
	/* PRODENTRY	*prod;		*/
	/* int		symb_no;	*/

EXTERN String VisitElemString();
	/* VSPTR	vselem;		*/

EXTERN Boolean ElemDepends();
	/* PRODENTRY	*prod;		*/
	/* VSPTR	elem1, elem2;	*/

EXTERN Boolean ElemCritical();
	/* VSPTR	elem, last;	*/

EXTERN void VisitArrange();
	/* PRODENTRY	*prod;		*/
	/* VSPTR	elem, after;	*/
