/* $Id: lookup_idl.c,v 1.5 1992/01/29 13:10:56 cogito Exp $ */

/****************************************
*					*
*	Version : 1.0			*
*					*
*	Module  : lookup_idl.c		*
*					*
*					*
*****************************************/


/****************************************
* includes				*
*****************************************/

#include "lookup_idl.h"

/****************************************
* global variables			*
*****************************************/

all_defs array_of_defs[MAX_DEFS];

/****************************************
* init_did_table			*
*****************************************/

int init_did_table (DS) SEQDef DS; {

/* builds the table of dids; returns the number of definitions */

	SEQDef x;
	Def def;
	SEQAttrdef y;
	Attrdef attrdef;
	int did,max_def=0;
	
	foreachinSEQDef(DS,x,def) {

		switch (typeof(def)) {

		case KTypedef  : did=def.VTypedef->did;
				 break;
		case KSymb     : did=def.VSymb->did;
				 break;
		case KProd     : did=def.VProd->did;
				 break;
		case KChain    : did=def.VChain->did;
				 break;
		
		}; /* of case */

		/* insert definition at its place */

		array_of_defs[did].def=def;

		/* find out the highest did */

		if (max_def<did) max_def=did;

		/* if def is a Symb, retrieve its attributes */

		if (typeof(def)==KSymb) {

			foreachinSEQAttrdef((def.VSymb)->attrs,y,attrdef) {
				array_of_defs[attrdef->did].attrdef=attrdef;
				if (max_def<attrdef->did) max_def=attrdef->did;
			};

		};

	};

	return(max_def);
	
};


/****************************************
* lookup_def				*
*****************************************/

Def lookup_def (did) {

/* returns a pointer to the definition with id did */

	return(array_of_defs[did].def);
};


/****************************************
* lookup_attrdef			*
*****************************************/

Attrdef lookup_attrdef (did) {

/* returns a pointer to the attributedefinition with id did */

	return(array_of_defs[did].attrdef);
};



