/* $Id: Gorto.h,v 3.3 1992/11/12 09:36:48 cogito Exp $ */

/*======================================================================*
 *									*
 *	FILE:		order/Gorto.h					*
 *									*
 *	CONTENTS:	Header file for the order implementation,	*
 *			modified for use with GORTO			*
 *									*
 *	AUTHOR:		Volker Niepel					*
 *									*
 *======================================================================*/


/************************************************************************
 *				 Includes				*
 ************************************************************************/

#include <stdio.h>
#include <string.h>
#include <X11/Intrinsic.h>

#define String IDLString
#define Boolean IDLBoolean
#include "set.h"
#include "LIGA.h"
#undef String
#undef Boolean

#include "LIGAMacros.h"

/************************************************************************
 *				Constants				*
 ************************************************************************/

/* Dependency types */
#define T_DIR		0x1		/* direct			*/
#define T_TRAN		0x2		/* transitive			*/
#define T_IND		0x4		/* induced			*/
#define T_ARR		0x8		/* arranged			*/
#define T_PART		0x10		/* partitioned			*/
#define T_MASK		0x1f		/* mask including all bits	*/

/* Flags used to set marks at dependencies */
#define T_MARK		0x20		/* dependency marked		*/
#define T_FOLLOWED	0x40		/* origin marked		*/

/* States of symbols and productions */
#define S_CYCLIC	0x1		/* cyclic			*/
#define S_ARRANGED	0x2		/* arranged			*/
#define S_CHANGED	0x4		/* changed			*/
#define S_PARTITIONED	0x8		/* partitions computed		*/
#define S_VISIT_SEQ	0x10		/* visit sequence computed	*/
#define S_FORCED	0x20		/* partition forced		*/
#define S_REDISPLAYED	0x40		/* redisplay already forced	*/

/* States of attributes */
#define A_HIDDEN	0x1		/* hidden attribute		*/
#define A_CRITICAL	0x2		/* critical attribute		*/

/* array bounds */
#define MAX_ENTRIES	10000		/* # of entries in ref_tab	*/
#define WORD_LENGTH	(sizeof(unsigned int)*8)	/* word length	*/
#define MAX_INT		0x7FFFFFFF	/* maximum int value		*/
#define MAX_ATNO	500		/* # of attributes in a rule	*/
/* #define MAX_SYMBNO	10		* # of symbols in a rule	*/
extern	int	MAX_SYMBNO;
#define MAX_RULENO	300		/* total # of rule		*/

/* ref_tab item tags */
#define EMPTY		-1		/* empty entry			*/
#define SYMB		0		/* symbol entry			*/
#define PROD		1		/* production entry		*/
#define ATTR		2		/* attribute entry		*/

/* graph states */
#define DIRECT 		0		/* direct graphs		*/
#define TRANSITIVE	1		/* transitive graphs		*/
#define INDUCED		2		/* induced graphs		*/
#define ARRANGED	3		/* arranged graphs		*/
#define PARTITIONED 	4		/* partitioned graphs		*/

/* visit classes */
#define VSASSIG		0		/* attribute evaluation		*/
#define VSCOND		1		/* condition evaluation		*/
#define VSVISIT		2		/* symbol visit or leave	*/
#define VSPUSH		3		/* push				*/
#define VSPOP		4		/* pop				*/


/************************************************************************
 *				  Macros				*
 ************************************************************************/

/* redefinition of Malloc and Free */
#define	Malloc(n)	XtMalloc(n)
#define Free(p)		{XtFree((char *) *(p)); *(p)=NULL;}

/* operations */
#define ODD(x)		((x)%2 == 1)
#define EVEN(x)		((x)%2 == 0)


/************************************************************************
 *		Type definitions for BITMATRIX and SLNODE		*
 ************************************************************************/

/* BITMATRIX is the internal data representation of attribute */
/* dependency graphs in the original order implementation     */
typedef BITVECTOR *BITMATRIX;

/* node structure of the list of symbol occurrences of a production */
typedef struct slnode {
	int		sid;		/* did of the symbol		*/
	int		pid;		/* did of the production	*/
 	struct slnode	*right;		/* right points to the next
					   symbol in the production	*/
	struct slnode	*down;		/* down points to the next
					   symbol with the same sid	*/
	int		start_col;	/* the starting column of this 
					   symbol occurence in the dp	*/
	int		start_row;	/* the start index of this
					   symbol occurence in the dp	*/
	Position	y;		/* y-coordinate in the drawn
					   graph			*/
	short		ord;		/* number of symbol instance	*/
} SLNODE;


/************************************************************************
 *		Internal representation of arrange options		*
 ************************************************************************/

typedef struct arrange_node {
	String			comment;
	int			did;
	SLNODE			*fromNode, *toNode;
	int			fromAid, toAid;
	struct arrange_node	*next;
} ARRANGE_NODE;


/************************************************************************
 *     Representation of dependencies and dependency graphs for GORTO	*
 ************************************************************************/

/* detail information for direct dependencies */
typedef struct {
	int	row;		/* position in the lido source */
} DIRECT_DETAIL;

/* detail information for arranged dependencies */
typedef union {
	ARRANGE_NODE	*node;	/* pointer to internal arrange node */
} ARRANGE_DETAIL;

/* detail information for induced dependencies */
typedef struct {
	SLNODE	*from;		/* the symbol instance from which this
				   dependency was induced	      */
} INDUCED_DETAIL;

/* detail information for transitive dependencies */
typedef struct {
	int	over_atno;
} TRANSITIVE_DETAIL;

/* detail information */
typedef union {
	DIRECT_DETAIL	direct;
	ARRANGE_DETAIL	arrange;
	INDUCED_DETAIL	induced;
	TRANSITIVE_DETAIL	transitive;
} DETAIL;

/* representation of a dependency */
typedef char DEPENDENCY;

/* representation of a dependency matrix */
typedef DEPENDENCY	*DEP_VECTOR;
typedef DEP_VECTOR	*DEP_MATRIX;
typedef DETAIL		*DET_VECTOR;
typedef DET_VECTOR	*DET_MATRIX;


/************************************************************************
 *	    Data structues used for computing visit sequences		*
 ************************************************************************/

/* assign detail information */
typedef struct {
	int		aid, apos;	/* attribute did and rel. pos	*/
	int		sid, sno;	/* symbol did and number	*/
	Call		idldef;		/* idl definition		*/
} ASSIGINFO;

/* condition detail information */
typedef struct {
	Call		idldef;		/* idl definition		*/
} CONDINFO;

/* visit detail information */
typedef struct {
	BITVECTOR	evalset;	/* already evaluated attributes	*/
	int		vssid;		/* symbol did			*/
	int		vssno;		/* symbol number		*/
	int		vsord;		/* number of visit		*/
} VISITINFO;

/* element structure of visit-sequence */
typedef struct vselem {
	BITVECTOR	deps;		/* attribute dependencies	*/
	struct vselem	*next;		/* next elem in visit-sequence	*/
	int		vscls;		/* VSASSIG | VSCOND | VSVISIT |
					   VSPUSH | VSPOP		*/
	union {
	ASSIGINFO	assig;		/* assign information		*/
	CONDINFO	cond;		/* condition information	*/
	VISITINFO	visit;		/* visit information		*/
	} vsinfo;
} VSELEM, *VSPTR;


/************************************************************************
 *		   Type definitions for ref_tab entries			*
 ************************************************************************/

/* attribute entry in the ref. table */
typedef struct attrdef {
	Attrdef		attr_def;	/* idl definition		*/
	int		pos;		/* rel. pos in the bit vector	*/
 	int		early;		/* early partition number	*/
	int		part;		/* the partition number		*/
	struct attrdef	*next, *last;	/* other attrs of this symbol	*/
	int		up_space;	/* available space in up dir.	*/
	int		down_space;	/* available space in down dir.	*/
	short		state;		/* A_HIDDEN | A_CRITICAL	*/
	Dimension	width;		/* width of drawn name		*/
	int		life_vsno;	/* global end of lifetime	*/
	SLNODE		*life_node;	/* symbol instance of last use	*/
} ATTRENTRY;

/* production activation record */
typedef struct {
	Position	lhs_x, rhs_x;	/* x coordinate of lhs and rhs	*/
	Widget		widget, state;	/* reference to created widgets	*/
} PAR;

/* symbol activation record */
typedef struct {
	Position	x, y;		/* x,y coordinates in the graph	*/
	Dimension	width, height;	/* width and height		*/
	Widget		widget, state;	/* reference to created widgets	*/
} SAR;

/* visit-sequence activation record */
typedef struct {
	Position	x, y;		/* x,y coordinates of vs	*/
	Widget		widget;		/* reference to created widgets	*/
} VSAR;

/* attribute lifetime information */
typedef struct {
	VSPTR		last_local;	/* last local use		*/
	VSPTR		last_global;	/* last global use		*/
} LIFETIME;

/* visit-sequence information record */
typedef struct {
	VSAR		*vsar;		/* activation record		*/
	String		geometry;	/* x,y position of window	*/
	Dimension	width, height;	/* width & height 		*/
	int		length;		/* length of visit-sequence	*/
	LIFETIME	*lifetimes;	/* lifetimes of attributes	*/
	VSPTR		marked_elem;	/* marked element of vs		*/
} VSINFO;

/* structure of production entry in the ref. table */
typedef struct {
	Prod		prod_def;	/* idl definition		*/
	SLNODE		*hdright;	/* head of symbol list		*/
	VSPTR		visitseq;	/* list of visit sequences	*/
	int		check_col;	/* index of last word of dp     */
	short		state;		/* state of this production	*/
	DEP_MATRIX	dp;		/* dependency graph		*/
	DET_MATRIX	dp_detail;	/* dependency details		*/
	Dimension	dep_width;	/* maximum dependency width	*/
	Dimension	rhs_width;	/* width of rhs			*/
	Dimension	rhs_height;	/* height of rhs		*/
	int		check_row;	/* last index of dp		*/
	PAR		*par;		/* production activation record	*/
	String		geometry;	/* x,y position of the window	*/
	VSINFO		*vs;		/* visit-sequence information	*/
} PRODENTRY;

/* structure of symbol entry in the ref. table */
typedef struct {
	Symb		symb_def;	/* idl definition		*/
	SLNODE		*hddown;	/* head of symbol list		*/
	int		attr_num;	/* number of attributes		*/
	int		part_num;	/* # of partitioned attr sets	*/
	short		state;		/* state of this symbol		*/
	Dimension	width, height;	/* size of drawn symbol		*/
	ATTRENTRY 	*first_attr;	/* first attribute		*/
	ATTRENTRY	*last_attr;	/* last attribute		*/
	DEP_MATRIX	ds;		/* dependency graph		*/
	DET_MATRIX	ds_detail;	/* dependency details		*/
	int		length;		/* number of not hidden attrs	*/
	SAR		*sar;		/* symbol activation record	*/
	String		geometry;	/* x,y position of the window	*/
} SYMBENTRY;

/* structure of ref_tab entry */
typedef struct {
	int		etag;		/* ATTR | SYMB | PROD		*/
	union {
	SYMBENTRY	symb;		/* symbol entry			*/
	PRODENTRY	prod;		/* production entry		*/
	ATTRENTRY	attr;		/* attribute entry		*/
 	} entry;
} ALLENTRIES;


/************************************************************************
 *		Type definitions used in branch_and_bound		*
 ************************************************************************/

typedef struct atnode{
	int atord;		/* order of considerratio of this attribute
				   its also the index number of this attr
				   in the atsort[] array                    */
	int partno;		/* its  current test allocation		    */
	int cost; 		/* cost of the partial solution		    */
	struct atnode *father;  /* pointer to its predecessor in the
				   partial solution			    */
	struct atnode *next;
} ATNODE;


/************************************************************************
 *			  Variable declarations				*
 ************************************************************************/

extern ALLENTRIES ref_tab[MAX_ENTRIES]; /* the reference table of symbols,
               		      productios, and attributes indexed by did */
extern int max_entry;	/* the maximum did used	*/
extern int min_entry;   /* the minimum did used */
extern int graphstate;  /* the state of graphs	*/

extern AttrEval ISexp;

extern Boolean Cyclic;
extern short graphstate_hint;


/************************************************************************
 *				  Files					*
 ************************************************************************/

extern FILE *In;	/* input file				*/
extern FILE *Out;	/* file pointer for graph output	*/
extern FILE *Prot;	/* Protocol file			*/


/************************************************************************
 *			  Function declarations				*
 ************************************************************************/

extern int  lookup_attr();
extern void init_ref_tab();
extern void cons_init_dp();
extern void cons_init_ds();
extern void transitiveclosure();
extern void partit();
extern void check_cycle();
extern void visitsequence();
extern void write_dataStruct();

extern Prod lookupProdByName();
extern Symb lookupSymbByName();

extern void read_orderOption();
extern void set_arrangeOption();

extern void MakeArrangeNode();

/* interface between option.c and predefdp.c */
typedef struct RArrangeHelp {
	int toAttrId;
	int fromAttrId;
	int toOrd;
	int toSymbId;
	int fromOrd;
	int fromSymbId;
	int prodId;
} *ArrangeHelp;
#define	KArrangeHelp 2
#define	NArrangeHelp ((ArrangeHelp)calloc(1, sizeof(struct RArrangeHelp)))

extern
void enter_depSymbol (/*
	ArrangeHelp   Ptr;
*/);

extern 
ArrangeHelp getIdArrangeSymbol (/*
	String symb, fromattr, toattr;
*/);

extern
void PredefDp (/*
	AttrEval	ae;
*/);

extern  VSPTR   *symbvsvect;/* now dynamic allocated array of size MAX_SYMBNO */
extern  SLNODE **symbvect;  /* now dynamic allocated array of size MAX_SYMBNO */


