/* $Id: initdp.c,v 2.10 1992/09/15 13:20:38 cogito Exp $ */
/* $Log: initdp.c,v $
 * Revision 2.10  1992/09/15  13:20:38  cogito
 * message texts updated
 *
 * Revision 2.9  1991/11/29  09:29:40  cogito
 * further exits corrected
 *
 * Revision 2.7  1991/10/02  15:13:53  cogito
 * Increased Length of error message buffer.
 *
 * Revision 2.6  1991/09/30  13:02:45  cogito
 * unnecessary and wrong output of error message removed
 *
 * Revision 2.5  1991/09/23  14:27:41  mjung
 * Added Errormessages using message. Protocoll-file is unchanged.
 *
 * Revision 2.4  1991/07/24  15:37:08  cogito
 * next try to fix the malloc(0) bug
 *
 * Revision 2.3  91/07/23  11:11:47  cogito
 * malloc(0) bug fixed again
 * 
 * Revision 2.2  91/07/18  11:42:16  cogito
 * adjust setsize to avoid malloc(0) call
 * 
 * Revision 2.1  91/06/10  13:25:40  cogito
 * sources for ORDER combined with GORTO
 *  */
static char rcs_id[]= "$Id: initdp.c,v 2.10 1992/09/15 13:20:38 cogito Exp $";

/************************************************************************
*									*
* 	Module  : initdp.c    						*
*									*
*       Version : 1.0							*
*									*
*       Author  : Jiyang Liu						*
*									*
*       Contains routines for Building the direct attribute dependency  *
*       graphs for  Rules, checking the consistency and completeness    *
*       of the AG, and routines for cycle checking.		        *
*									*
************************************************************************/

	/*
	 * Angepasst zur Anbindung an GORTO (Graphical Order Tool).
	 * Alle Aenderungen sind mit #ifdef GORTO gekennzeichnet.
	 *
	 *		25.04.90	Volker Niepel
	 */

/* includes */

#ifndef GORTO
#include "order.h"
#else
#include "Gorto.h"
#endif
#include "ligaconsts.h"
#include "printerr.h"
/* macros */

#define sgl 0x00000001
#define DEFINING_OCCURRENCE (((sno == 0)&&(ref_tab[aid].entry.attr.attr_def->\
					 class == ATCLSYNT))||\
			     ((sno > 0)&&(ref_tab[aid].entry.attr.attr_def->\
			                  class == ATCLINH)))
#ifndef GORTO
#define WAG_TEST  (ref_tab[pid].entry.prod.init_dp[check_row][check_word] &\
		  sgl << check_bit) 
#else
#define WAG_TEST  (ref_tab[pid].entry.prod.dp[check_row][check_col] & T_DIR)
#endif

#define ERR_BUFF_LEN 200

/* functions */

void cons_init_dp();
void enter_vs_list();
void enter_cond_deps();
void enter_dp_matrix();
bool is_complete();
bool is_consistent();
char *pr_graphstate_text();
bool check_rule_cycle();
bool check_symb_cycle();
void check_cycle();
int  lookup_attr ();

/*************************************************************************
*									 *
*	void cons_init_dp();						 *
*	build the initial attribute dependency graphs for all		 *
*       productions.							 *
*	and check the consistency and completeness of the AG.		 *
*									 *
*************************************************************************/

static int FailVar = 0;
#define FailAfterInit(i) FailVar = i


void
cons_init_dp(IS)
AttrEval IS;
{

SEQAttribution x;
SEQAttrrule y;
SEQExpr  rhs_exprs;
Attribution attribution;
Attrrule attrrule;
Expr lhs_expr;
SLNODE *slnptr;

int pid, row, aid, sno;
int i;

/* go through the sequence of all attributions */

foreachinSEQAttribution(IS->attrrules, x, attribution) {
  pid = attribution->prodid;

  /* go through the sequence of all attribution rules in an attribution */
  
  if (attribution->attrrules != NULL)
   foreachinSEQAttrrule(attribution->attrrules, y, attrrule) 
    if (typeof(attrrule) == KCall) 
        if (strcmp(attrrule.VCall->name, "assign") == 0) {
	  
	/* left hand side of the attrrule */
	   retrievefirstSEQExpr(attrrule.VCall->params, lhs_expr);
	   if (typeof(lhs_expr) == KAttracc) {
	      aid = lhs_expr.VAttracc->attrid;
	      sno = lhs_expr.VAttracc->symbno;

	      slnptr = ref_tab[pid].entry.prod.hdright;
              for (i=0; i<sno; i++) slnptr = slnptr->right;
	      row = slnptr->start_row + ref_tab[aid].entry.attr.pos;

	/* check for consistency of the AG */
	      
	      if (is_consistent(pid, sno, aid)) {
	
	        /* the rhs seqence of expressions of the attrrule  */

                 rhs_exprs = tailSEQExpr(attrrule.VCall->params);
		 if (rhs_exprs != NULL)
	            enter_dp_matrix(rhs_exprs, pid, row);
               
	      }
              else FailAfterInit(3);
	   }
	   else {
	      err_setpos (lhs_expr.VLiteral->row, lhs_expr.VLiteral->col);
	      err_print_error ("Left Hand Side of attrrule is not an attribute.");
              fprintf(Prot, "*** ERROR ***  lhs of attrrule is not an attribute. ***\n");
              exit(3); /* exit ok here, should be DEADLY error */
           }
        
	}
	else /* CONDITION function calls , To initiate the visit-sequence
		  list of this rule, i.e. prod.visitseq  */

           enter_vs_list(attrrule.VCall, pid);
	   
   /* check for completeness in this rule */
   if (!is_complete(pid)) {
/*      char errmsgbuff[ERR_BUFF_LEN];

      err_setpos (ref_tab[pid].entry.attr.attr_def->row, 
                  ref_tab[pid].entry.attr.attr_def->col);
      sprintf (errmsgbuff, "computation %s = ...; is missing in RULE %s",
	       ref_tab[aid].entry.attr.attr_def->name,
	       ref_tab[pid].entry.prod.prod_def->dname);
      err_print_error(errmsgbuff);
      fprintf(Prot, "*** ERROR *** %s\n", errmsgbuff);
 */ 
/* Kalle: deleted because error message is already printed in is_complete() */
      FailAfterInit(3);
   }
  
}

if (FailVar != 0) exit (FailVar);

return;
} /* end of cons_init_dp() */




/************************************************************************
*									*
*	void enter_dp_matrix()						*
*	enter the dependency relations into one row of the bit-matrix	*	
*	representing the initial dependency graph of the production.    *
*									*
************************************************************************/

void
enter_dp_matrix(seqexpr,pid, row)
SEQExpr seqexpr;
int  pid, row;

{
SEQExpr exprs;
Expr expr;
SLNODE *slnptr;
int i, aid, sno;
#ifndef GORTO
int col_word, col_bit;
#endif


foreachinSEQExpr(seqexpr, exprs, expr) 
   switch(typeof(expr)) {
      case KAttracc:
	   aid = expr.VAttracc->attrid;
	   sno = expr.VAttracc->symbno;
	   slnptr = ref_tab[pid].entry.prod.hdright;
	   for (i=0; i<sno; i++) slnptr = slnptr->right;
#ifndef GORTO
	   col_word = slnptr->start_col + ref_tab[aid].entry.attr.pos/WORD_LENGTH;
	   col_bit = ref_tab[aid].entry.attr.pos%WORD_LENGTH;
	/* enter an item in init_dp of this production */
	   ref_tab[pid].entry.prod.init_dp[row][col_word] |= sgl<<col_bit;
	   ref_tab[pid].entry.prod.dp[row][col_word] |= sgl<<col_bit;
#else
	/* enter an item in init_dp of this production */
	   ref_tab[pid].entry.prod.dp[row]
		[slnptr->start_row + ref_tab[aid].entry.attr.pos] = T_DIR;
	   ref_tab[pid].entry.prod.dp_detail[row]
		[slnptr->start_row + ref_tab[aid].entry.attr.pos]
		.direct.row = expr.VAttracc->row;
#endif
	   break;

      case KIncluding:
	   /* genattr is one of the inherited attr's of lhs */
	   aid = expr.VIncluding->genattrid;
	   slnptr = ref_tab[pid].entry.prod.hdright;
#ifndef GORTO
	   col_word = slnptr->start_col + ref_tab[aid].entry.attr.pos/WORD_LENGTH;
	   col_bit = ref_tab[aid].entry.attr.pos%WORD_LENGTH;
	/* enter an item in init_dp of this production */
	   ref_tab[pid].entry.prod.init_dp[row][col_word] |= sgl<<col_bit;
	   ref_tab[pid].entry.prod.dp[row][col_word] |= sgl<<col_bit;
#else
	/* enter an item in init_dp of this production */
	   ref_tab[pid].entry.prod.dp[row]
	   	[slnptr->start_row + ref_tab[aid].entry.attr.pos] = T_DIR;
	   ref_tab[pid].entry.prod.dp_detail[row]
	   	[slnptr->start_row + ref_tab[aid].entry.attr.pos]
		.direct.row = expr.VIncluding->row;
#endif
	   break;

      case KCall:
	   if (expr.VCall->params != NULL) {
	   enter_dp_matrix(expr.VCall->params, pid, row);
  	   }
	   break;

      case KConstit:
	   {
	     char errmsgbuff[ERR_BUFF_LEN];

	     err_setpos(ref_tab[pid].entry.prod.prod_def->row, 
                      ref_tab[pid].entry.prod.prod_def->col);
	     sprintf (errmsgbuff, "in RULE %s FROM EXPAND", 
			ref_tab[pid].entry.prod.prod_def->dname);
	     err_print_error (errmsgbuff);    
	     fprintf(Prot, "*** ERROR *** %s\n", errmsgbuff);
	     exit(3); /* exit is ok here */
	   }
	   break;
     
      default: break;
	   
   } /* switch */


return;
} /* enter_dp_matrix() */

/************************************************************************
*									*
*	bool is_consistent()						*
*	check in each rule for the consistency of the AG.		*
*									*
************************************************************************/

bool
is_consistent(pid, sno, aid)
int pid, sno, aid;

{
#ifndef GORTO
int check_row, check_word, check_bit, i;
#else
int check_row, check_col, i;
#endif

SLNODE *slnptr;

slnptr = ref_tab[pid].entry.prod.hdright;
for (i=0; i<sno; i++) slnptr = slnptr->right;

check_row = ref_tab[pid].entry.prod.check_row;
#ifndef GORTO
check_word = slnptr->start_col + ref_tab[aid].entry.attr.pos/WORD_LENGTH;
check_bit = ref_tab[aid].entry.attr.pos%WORD_LENGTH;
#else
check_col = slnptr->start_row + ref_tab[aid].entry.attr.pos;
#endif

if (DEFINING_OCCURRENCE)
   if (WAG_TEST == 0) {
#ifndef GORTO
      ref_tab[pid].entry.prod.init_dp[check_row][check_word] |= sgl << check_bit;
#else
      ref_tab[pid].entry.prod.dp[check_row][check_col] = T_DIR;
#endif
      return(TRUE);
    }
    else {
       char errmsgbuff[ERR_BUFF_LEN];
       
       sprintf (errmsgbuff, 
	"computation %s.%s = ...; occurrs multiply in RULE %s", 
  	   ref_tab[slnptr->sid].entry.symb.symb_def->dname,
           ref_tab[aid].entry.attr.attr_def->name,
           ref_tab[pid].entry.prod.prod_def->dname);
       err_setpos (ref_tab[pid].entry.prod.prod_def->row, 
		   ref_tab[pid].entry.prod.prod_def->col);
       err_print_error (errmsgbuff);
       fprintf(Prot, "*** ERROR *** %s\n", errmsgbuff);
       return (FALSE);
    }
else {
   char errmsgbuff[ERR_BUFF_LEN];
   
   sprintf (errmsgbuff, "computation %s.%s = ...; must not occur in RULE %s",
  	   ref_tab[slnptr->sid].entry.symb.symb_def->dname,
           ref_tab[aid].entry.attr.attr_def->name,
           ref_tab[pid].entry.prod.prod_def->dname);
   err_setpos(ref_tab[aid].entry.attr.attr_def->row, 
	      ref_tab[aid].entry.attr.attr_def->col);
   err_print_error (errmsgbuff);
   fprintf(Prot, "*** ERROR *** %s\n", errmsgbuff);
   return (FALSE);
}

} /* is_consistent() */
	      

/************************************************************************
*									*
*	bool is_complete()						*
*	check in each rule for the completeness of the AG.		*
*									*
************************************************************************/

bool
is_complete(pid)
int pid;
{

int sno, sid, aid;
#ifndef GORTO
int check_row, check_word, check_bit;
#else
int check_row, check_col;
#endif
SLNODE *slnptr;
SEQAttrdef  x;
Attrdef attrdef;


sno = 0;
check_row =  ref_tab[pid].entry.prod.check_row;

slnptr = ref_tab[pid].entry.prod.hdright;
while (slnptr != NULL) {
   sid = slnptr->sid;

   if ( ref_tab[sid].entry.symb.attr_num > 0)
      foreachinSEQAttrdef(ref_tab[sid].entry.symb.symb_def->attrs, x, attrdef) {
         aid = attrdef->did;
         if (DEFINING_OCCURRENCE) {

#ifndef GORTO
            check_word = slnptr->start_col + ref_tab[aid].entry.attr.pos/WORD_LENGTH;
            check_bit = ref_tab[aid].entry.attr.pos%WORD_LENGTH;
#else
            check_col = slnptr->start_row + ref_tab[aid].entry.attr.pos;
#endif

	    if (WAG_TEST == 0)  /* incomplete */ 
	    {
	        char errmsgbuff[ERR_BUFF_LEN];
		
		sprintf (errmsgbuff, 
			"computation %s.%s = ...; is missing in RULE %s",
			 ref_tab[sid].entry.symb.symb_def->dname,
			 ref_tab[aid].entry.attr.attr_def->name,
			 ref_tab[pid].entry.prod.prod_def->dname);
		err_setpos(ref_tab[pid].entry.prod.prod_def->row, 
			   ref_tab[pid].entry.prod.prod_def->col);
		err_print_error(errmsgbuff);
		fprintf(Prot, "*** ERROR *** %s\n", errmsgbuff);
		return (FALSE);
	    }
	    /*  FailAfterInit(1); */
        
  	 
         } /* if (DEF... ) */
      } /* foreach */

   /* next symbol occurrence */
   slnptr = slnptr->right;
   sno++;
}/* while */

return (TRUE);
} /* is_complete() */

/********************************************************
*	char *pr_graphstate_text()			*
********************************************************/

char *
pr_graphstate_text(graph_state)
int graph_state;

{
	switch (graph_state) {

	case DIRECT:   		return("DIRECT");
				break;
	 
	case TRANSITIVE:	return("TRANSITIV");
				break;

	case INDUCED:		return("INDUCED");
				break;

	case PARTITIONED:  	return("PARTITIONED");
				break;

	default:		return("UNKNOWN");

	}
} /* pr_graphstate_text() */
      

/****************************************************************
*	bool check_rule_cycle(pid)           			*
*	check cycles in attribute dependency graphs of    	*
*	rules 							*
****************************************************************/

bool
check_rule_cycle ()

{
int pid;
SLNODE *slnptr;
PRODENTRY *prod;
SYMBENTRY *symb;
int atno, aid;
bool firsttime = TRUE;


for (pid = min_entry; pid <= max_entry; pid++)
   if (ref_tab[pid].etag == PROD) {

      prod = & ref_tab[pid].entry.prod;
      for (slnptr=prod->hdright; slnptr != NULL; slnptr = slnptr->right) {
         symb = & ref_tab[slnptr->sid].entry.symb;
         for (atno = 0; atno < symb->attr_num; atno++)
#ifndef GORTO
            if (prod->dp[atno+slnptr->start_row][atno/WORD_LENGTH+slnptr->start_col] 
                & (0x1 << (atno % WORD_LENGTH))) {
       	       prod->cyclic = TRUE;

               if (firsttime) {
		  char errmsgbuff[ERR_BUFF_LEN];
		  err_setpos(0,0);
		  if (graphstate == PARTITIONED)
			sprintf (errmsgbuff, 
"did not find evaluation order; see ord_info, add dependencies, or use gorto");
		  else	sprintf (errmsgbuff,
"%s cyclic dependencies; see ord_info, or use gorto",
			   pr_graphstate_text(graphstate));

		  err_print_error (errmsgbuff);

                  fprintf(Prot,"\n\n*** ERROR *** CYCLE IN %s GRAPHS FOR RULES:\n\n",
		          pr_graphstate_text(graphstate));
                  firsttime = FALSE;
               }

               aid = lookup_attr (slnptr->sid, atno);

		{char errmsgbuff[ERR_BUFF_LEN];      
		err_setpos(prod->prod_def->row, prod->prod_def->col);
		sprintf (errmsgbuff, "evaluation order for %s.%s not found",
			symb->symb_def->dname,
			ref_tab[aid].entry.attr.attr_def->name);
		err_print_error(errmsgbuff);
		}

  	       fprintf (Prot, "*** ERROR *** RULE %s SYMBOL %s ATTRIBUTE %s\n",
		       prod->prod_def->dname, symb->symb_def->dname,
	               ref_tab[aid].entry.attr.attr_def->name);
            }
#else
            if (prod->dp[atno+slnptr->start_row][atno+slnptr->start_row]) {
       	       prod->state |= S_CYCLIC;
	       firsttime = FALSE;
            }
#endif
      }
   }
return (!firsttime);  /* return TRUE if cycle exists */

} /* check_rule_cycle () */


/****************************************************************
*       bool check_symb_cycle(sid)                              *
*       check cycles in attribute dependency graphs of all      *
*       symbols                                                 *
****************************************************************/

bool
check_symb_cycle ()

{

int sid;
SYMBENTRY *symb;
int atno, aid;
bool firsttime = TRUE;

for (sid = min_entry; sid <= max_entry; sid++)
   if (ref_tab[sid].etag == SYMB) {
      symb = & ref_tab[sid].entry.symb;

      for (atno = 0; atno < symb->attr_num; atno++)
#ifndef GORTO
         if (symb->ds[atno][atno/WORD_LENGTH] & ((0x1 << (atno % WORD_LENGTH)))) {
            symb->cyclic = TRUE;
 
            if (firsttime) {
	       char errmsgbuff[ERR_BUFF_LEN];

	       err_setpos(0,0);
		  if (graphstate == PARTITIONED)
			sprintf (errmsgbuff, 
"did not find evaluation order; see ord_info, add dependencies, or use gorto");
		  else	sprintf (errmsgbuff,
"%s cyclic dependencies; see ord_info, or use gorto",
			   pr_graphstate_text(graphstate));
	       err_print_error (errmsgbuff);

	       fprintf(Prot,"\n\n*** ERROR *** CYCLE IN %s GRAPHS FOR SYMBOLS:\n\n",
	               pr_graphstate_text(graphstate));
	       firsttime = FALSE;
	    }

            aid = lookup_attr (sid, atno);
            fprintf(Prot,"*** ERROR *** SYMBOL %s ATTRIBUTE %s\n",
	            symb->symb_def->dname, ref_tab[aid].entry.attr.attr_def->name);

      }
#else
         if (symb->ds[atno][atno]) {
            symb->state |= S_CYCLIC;
	    firsttime = FALSE;
      }
#endif
   }

return (!firsttime); /* return TRUE if cycle exists */

} /* check_symb_cycle() */

/****************************************************************
*       void check_cycle(sid)                                   *
*       check cycles in attribute dependency graphs of all      *
*       symbols and rules                                       *
****************************************************************/

void check_cycle()

{

bool cyclic;

cyclic = check_rule_cycle();

cyclic = check_symb_cycle() || cyclic;

#ifndef GORTO
if (cyclic) {

   fprintf(Prot, "*** Error! Cycles in %s GRAPHS *****\n", pr_graphstate_text(graphstate));
   exit(3); /* exit ok here */

}
#else
Cyclic = cyclic;
#endif

return;

} /* check_cycle( ) */

/****************************************************************
*	int lookup_attr () 					*
*	look up the did of an attribute occurrence using	*
*	the symbol's did and the attr's pos.			*
****************************************************************/

int
lookup_attr (sid, pos)
int sid, pos;

{
SYMBENTRY *symb;
SEQAttrdef restattrs;
Attrdef attr;
int atno;

symb = & ref_tab[sid].entry.symb;
atno = 0;

foreachinSEQAttrdef(symb->symb_def->attrs, restattrs, attr)
   if (atno != pos)  atno++;
   else return (attr->did);

} /* lookup_attr () */

/****************************************************************
*       void enter_vs_list(seqexpr, pid)			*
*       initialize the visitseq list of this rule by 		*
*       entering the cond items.				*
****************************************************************/

void
enter_vs_list(call,  pid)
Call call;
int pid;

{ 
VSPTR cond;
int maxword;
SEQExpr seqexpr;

maxword = ref_tab[pid].entry.prod.check_col + 1;

	/* make a new cond node */

cond = (VSELEM *) Malloc (sizeof(VSELEM));
cond->vscls = VSCOND;

/* Kalle: */
/* cond->deps = mkemptyset (maxword-1);  * previos version */
if ( maxword > 0 )			/* now: to avoid malloc(0) */
    cond->deps = mkemptyset (maxword-1);
else
    /* cond->deps = (BITVECTOR)NULL;  results in segmentation fault */
    cond->deps = mkemptyset (maxword);

/*
** cond->deps = (BITVECTOR)Malloc(sizeof(unsigned int)*maxword);
** cond-> must be inintialized.
*/

seqexpr = call->params;
enter_cond_deps(seqexpr, cond, pid); 	/*enter cond->deps */

cond->vsinfo.cond.idldef = call;    /* pointer to idl def */
cond->next = NULL;

	/* insert new cond node into visitseq list */

if (ref_tab[pid].entry.prod.visitseq == NULL)
   ref_tab[pid].entry.prod.visitseq = cond;
else {
   cond->next = ref_tab[pid].entry.prod.visitseq;
   ref_tab[pid].entry.prod.visitseq = cond;
}

return;
} /* enter_vs_list() */


/****************************************************************
*       void enter_cond_deps(seqexpr, pid)                      *
*       enter the depended attributes of a condition. 		*
****************************************************************/

void
enter_cond_deps(seqexpr, cond, pid)
SEQExpr seqexpr;
VSPTR cond;
int pid;

{
SEQExpr exprs;
Expr expr;
SLNODE *slnptr;
int i, aid, sno;
int col_word, col_bit;

foreachinSEQExpr(seqexpr, exprs, expr)
   switch(typeof(expr)) {
      case KAttracc:
           aid = expr.VAttracc->attrid;
           sno = expr.VAttracc->symbno;
           slnptr = ref_tab[pid].entry.prod.hdright;
           for (i=0; i<sno; i++) slnptr = slnptr->right;
           col_word = slnptr->start_col + ref_tab[aid].entry.attr.pos/WORD_LENGTH;
           col_bit = ref_tab[aid].entry.attr.pos%WORD_LENGTH;
	   
	   (cond->deps)[col_word] |= sgl<<col_bit;
	   break;

      case KIncluding:
           /* genattr is one of the inherited attr's of lhs */
           aid = expr.VIncluding->genattrid;
           slnptr = ref_tab[pid].entry.prod.hdright;
           col_word = slnptr->start_col + ref_tab[aid].entry.attr.pos/WORD_LENGTH;
           col_bit = ref_tab[aid].entry.attr.pos%WORD_LENGTH;
	   (cond->deps)[col_word] |= sgl<<col_bit;
           break;

      case KCall:
           if (expr.VCall->params != NULL) 
 	      enter_cond_deps(expr.VCall->params, cond, pid);
           break;

      case KConstit:
	   {
	     char errmsgbuff[ERR_BUFF_LEN];
	     
	     sprintf (errmsgbuff, "in RULE %s FROM EXPAND", 
		      ref_tab[pid].entry.prod.prod_def->dname);
	     err_setpos(ref_tab[pid].entry.prod.prod_def->row, 
			ref_tab[pid].entry.prod.prod_def->col);
	     err_print_error(errmsgbuff);
	     fprintf(Prot, "*** ERROR *** %s\n", errmsgbuff);
	     exit(3); /* exit is ok here */
	   }
           break;

      default: break;

   } /* switch */

return;
} /* enter_cond_deps() */







