#ifndef ENVMOD_H
#define ENVMOD_H

/* $Id: envmod.h,v 1.10 1992/04/12 02:10:04 waite Exp $ */
/* Copyright 1991, The Regents of the University of Colorado
 * Permission is granted to use any portion of this file for any purpose,
 * commercial or otherwise, provided that this notice remains unchanged.
 */

#include "deftbl.h"

#define MaxIdn 8192			/* Maximum number of identifiers */

typedef struct EnvImpl *Environment;	/* Set of Identifier/Definition pairs */
typedef struct RelElt *Scope;		/* Single region */
typedef struct AccessMechanism *Access;	/* Current access nested */

struct EnvImpl {		/* Addressing environment */
   Access nested;		   /* Constant-time access */
   Environment parent;		   /* Enclosing environment */
   Scope relate;		   /* Current region */
};
struct RelElt {
   int idn;			   /* Identifier */
   Scope nxt;			   /* Next association for the current region */
   DefTableKey key;		   /* Definition */
};
typedef struct StkElt *StkPtr;	/* List implementing a definition stack */
struct StkElt {
   StkPtr out;			   /* Superseded definitions */
   DefTableKey key;		   /* Definition */
   Environment env;		   /* Environment containing this definition */
};
struct AccessMechanism {	/* Current nested of the access mechanism */
   StkPtr IdnTbl[MaxIdn];	   /* Stacks of definitions */
   Environment CurrEnv;		   /* Environment for the array nested */
};

#define NoEnv ((Environment)0)

#define HiddenBy(env,idn) (SetEnv(env), (env)->nested->IdnTbl[idn])
#define HiddenKey(stkptr) ((stkptr)->key)
#define NextHidden(stkptr) ((stkptr)->out)

#define DefinitionsOf(env) ((env)->relate)
#define IdnOf(relate) ((relate) ? (relate)->idn : 0)
#define KeyOf(relate) ((relate) ? (relate)->key : NoKey)
#define NextDefinition(relate) ((relate) ? (relate)->nxt : (Scope)0)


/***/
extern Environment NewEnv();
/* Establish a new environment
 *    On exit-
 *       NewEnv=new environment
 ***/
 
/***/
#if defined(__cplusplus) || defined(__STDC__)
extern void SetEnv(Environment env);;
#else
extern void SetEnv();
#endif
/* Make certain that the nested of the array reflects env
 ***/
 
/***/
#if defined(__cplusplus) || defined(__STDC__)
extern Environment NewScope(Environment env);
#else
extern Environment NewScope();
#endif
/* Establish a new scope within an environment
 *    On exit-
 *       NewScope=new environment that is a child of env
 ***/
 
/***/
#if defined(__cplusplus) || defined(__STDC__)
extern DefTableKey DefineIdn(Environment env, int idn);
#else
extern DefTableKey DefineIdn();
#endif
/* Define an identifier in a scope
 *    If idn is defined in env then on exit-
 *       DefineIdn=key for idn in env
 *    Else let n be a previously-unused definition table key
 *    Then on exit-
 *       DefineIdn=n
 *       idn is defined in env with the key n
 ***/

/***/
#if defined(__cplusplus) || defined(__STDC__)
extern DefTableKey KeyInEnv(Environment env, int idn);
#else
extern DefTableKey KeyInEnv();
#endif
/* Find the key for an identifier in an environment
 *    If idn is defined in env then on exit-
 *       KeyInEnv=key for idn in env
 *    Else if idn is defined in some ancestor of env then on exit-   
 *       KeyInEnv=KeyInEnv(Parent(env),idn)
 *    Else on exit-
 *       KeyInEnv=key that represents no definition
 ***/

/***/
#if defined(__cplusplus) || defined(__STDC__)
extern DefTableKey KeyInScope(Environment env, int idn);
#else
extern DefTableKey KeyInScope();
#endif
/* Find the key for an identifier in a scope
 *    If idn is defined in env then on exit-   
 *       KeyInScope=key for idn in env
 *    Else on exit- 
 *       KeyInScope=key that represents no definition
 ***/
#endif
