/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/Filename.h"
#include "inc/Flag_.h"
#include "inc/InpKind_.h"
#include "inc/RunSpc.h"
#include "inc/Signal_.h"
#include "inc/Status_.h"
#include "inc/TClass_.h"


GetAllReqs(SignalPtr, FilHdr)
   tp_Signal *SignalPtr;
   tp_FilHdr FilHdr;
{
   TryGetAllReqs(SignalPtr, FilHdr);
   while (*SignalPtr == SIGNAL_DBMod || *SignalPtr == SIGNAL_SourceMod) {
      TryGetAllReqs(SignalPtr, FilHdr); }/*while*/;
   }/*GetAllReqs*/;


TryGetAllReqs(SignalPtr, FilHdr)
   tp_Signal *SignalPtr;
   tp_FilHdr FilHdr;
{
   GetReqs(SignalPtr, FilHdr, IK_Trans);
   if (*SignalPtr != NIL) {
      return; }/*if*/;
   Restore(SignalPtr, FilHdr, TRUE);
   }/*TryGetAllReqs*/;


GetReqs(SignalPtr, FilHdr, InpKind)
   tp_Signal *SignalPtr;
   tp_FilHdr FilHdr;
   tp_InpKind InpKind;
{
   boolean DataFlag;
   int Tag;

   *SignalPtr = NIL;
   FORBIDDEN(!NeedsData(FilHdr, InpKind));
   if (!IsUpToDate(FilHdr)) {
      GetFile(SignalPtr, FilHdr);
      if (*SignalPtr != NIL) {
	 return; }/*if*/; }/*if*/;
   DataFlag = (NeedsElmsData(FilHdr, InpKind) && !IsElmUpToDate(FilHdr));
   if (DataFlag
       || (InpKind_IsTransName(InpKind) && !IsElmNameUpToDate(FilHdr))) {
      Tag = 1;
      GetElms(SignalPtr, FilHdr, DataFlag, &Tag); }/*if*/;
   }/*GetReqs*/;


GetFile(SignalPtr, FilHdr)
   tp_Signal *SignalPtr;
   tp_FilHdr FilHdr;
{
   tps_RunSpc _RunSpc; tp_RunSpc RunSpc = &_RunSpc;
   tp_Status MinStatus;
   tp_Tool Tool;
   tp_TClass TClass;
   tp_Date MaxSonModDate;

   *SignalPtr = NIL;

   if (IsSource(FilHdr)) {
      Update_SrcFilHdr(SignalPtr, FilHdr, FALSE);
      return; }/*if*/;

   if (FilHdr_Flag(FilHdr, FLAG_Get)) {
      Set_CompoundConfirm(FilHdr, STAT_Circular);
      return; }/*if*/;
   Set_Flag(FilHdr, FLAG_Get);

   GetInps(SignalPtr, &MinStatus, &MaxSonModDate, FilHdr);
   if (*SignalPtr != NIL) {
      goto done; }/*if*/;
   Tool = FilHdr_Tool(FilHdr);
   TClass = Tool_TClass(Tool);
   MinStatus = Get_ToolStatus(Tool, MinStatus);
   if (MinStatus == STAT_SysAbort) {
      if (IsUpToDate(FilHdr)) {
	 FORBIDDEN((FilHdr_Status(FilHdr) != STAT_Circular) && (TClass != TC_Hook));
	 goto done; }/*if*/;
      if (LogLevel >= 6) Do_Log("Aborting", FilHdr);
      Set_CompoundStatus(FilHdr, MinStatus);
      goto done; }/*if*/;
   FORBIDDEN(MinStatus <= STAT_Unknown);
   /*select*/{
      if (TClass == TC_Error || TClass == TC_Warning
	  || TClass == TC_Browser || TClass == TC_Hook
	  || FilHdr_OldStatus(FilHdr) == STAT_SysAbort
	  || FilHdr_ConfirmDate(FilHdr) < MaxSonModDate) {
	 if (TClass != TC_Error && TClass != TC_Warning) {
	    Restore_Inps(SignalPtr, FilHdr);
	    if (*SignalPtr != NIL) {
	       goto done; }/*if*/; }/*if*/;
	 FilHdr_RunSpc(RunSpc, FilHdr);
	 /*select*/{
	    if (IsSystem_Tool(Tool)) {
	       if (LogLevel >= 4) Do_Log("Generating", FilHdr);
	       Exec(SignalPtr, RunSpc, MinStatus, FALSE);
	    }else{
	       if (LogLevel >= 3) Do_Log("Generating", FilHdr);
	       Run(SignalPtr, RunSpc, MinStatus, FALSE); };}/*select*/;
	 Ret_RunSpc(RunSpc);
      }else{
	 if (LogLevel >= 6) Do_Log("Verifying", FilHdr);
	 if (MinStatus > FilHdr_OldStatus(FilHdr)) {
	    MinStatus = FilHdr_OldStatus(FilHdr); }/*if*/;
	 Set_CompoundConfirm(FilHdr, MinStatus); };}/*select*/;

done:;
   Clr_Flag(FilHdr, FLAG_Get);
   }/*GetFile*/;


GetInps(SignalPtr, MinStatusPtr, MaxSonModDatePtr, FilHdr)
   tp_Signal *SignalPtr;
   tp_Status *MinStatusPtr;
   tp_Date *MaxSonModDatePtr;
   tp_FilHdr FilHdr;
{
   tp_LocInp LocInp;
   tp_FilInp FilInp;
   tp_FilHdr InpFilHdr;
   tp_InpKind InpKind;
   tp_Status Status;
   tp_Date ModDate;

   *SignalPtr = NIL;
   *MinStatusPtr = STAT_OK;
   *MaxSonModDatePtr = 1;

   LocInp = FilHdr_LocInp(FilHdr);
   while (LocInp != 0) {
      FilInp = LocInp_FilInp(LocInp);
      InpFilHdr = FilInp_FilHdr(FilInp);
      InpKind = FilInp_InpKind(FilInp);

      if (NeedsData(InpFilHdr, InpKind)) {
	 GetReqs(SignalPtr, InpFilHdr, InpKind);
	 if (*SignalPtr != NIL) {
	    Ret_FilHdr(InpFilHdr);
	    Ret_FilInp(FilInp);
	    return; }/*if*/;

         Status = FilHdr_Status(InpFilHdr);
	 if (Status < STAT_Warning && InpKind_IsAnyOK(InpKind)) {
	    Status = STAT_Warning; }/*if*/;
         if (Status < *MinStatusPtr) *MinStatusPtr = Status;
         ModDate = FilHdr_ModDate(InpFilHdr);
         if (ModDate > *MaxSonModDatePtr) *MaxSonModDatePtr = ModDate;

	 /*select*/{
	    if (NeedsElmsData(InpFilHdr, InpKind)) {
	       Status = FilHdr_ElmStatus(InpFilHdr);
	       if (Status < STAT_Warning && InpKind_IsAnyOK(InpKind)) {
		  Status = STAT_Warning; }/*if*/;
	       if (Status < *MinStatusPtr) *MinStatusPtr = Status;
	       ModDate = FilHdr_ElmModDate(InpFilHdr);
	       if (ModDate > *MaxSonModDatePtr) *MaxSonModDatePtr = ModDate;
	    }else if (InpKind_IsTransName(InpKind)) {
	       Status = FilHdr_ElmNameStatus(InpFilHdr);
	       if (Status < STAT_Warning && InpKind_IsAnyOK(InpKind)) {
		  Status = STAT_Warning; }/*if*/;
	       if (Status < *MinStatusPtr) *MinStatusPtr = Status;
	       ModDate = FilHdr_ElmNameModDate(InpFilHdr);
	       if (ModDate > *MaxSonModDatePtr) *MaxSonModDatePtr = ModDate;
	       };}/*select*/; }/*if*/;
      Ret_FilHdr(InpFilHdr);
      LocInp = FilInp_Next(FilInp);
      Ret_FilInp(FilInp); }/*while*/;
   FORBIDDEN(*MinStatusPtr <= STAT_Unknown);
   }/*GetInps*/;


GetElms(SignalPtr, FilHdr, DataFlag, TagPtr)
   boolean *SignalPtr;
   tp_FilHdr FilHdr;
   boolean DataFlag;
   int *TagPtr;
{
   boolean CompoundFlag;
   int Tag;
   tp_LocElm LocElm;
   tp_FilElm FilElm;
   tp_FilHdr ElmFilHdr, SCC_ElmFilHdr, SCC_FilHdr;
   tp_Status Status, MinStatus, MinNameStatus;
   tp_Date ModDate, MaxModDate, MaxNameModDate;

   FORBIDDEN(FilHdr_Status(FilHdr) <= STAT_Error);
   FORBIDDEN(FilHdr_Tag(FilHdr) != 0);
   FORBIDDEN(DataFlag ? IsElmUpToDate(FilHdr) : IsElmNameUpToDate(FilHdr));

   *SignalPtr = NIL;
   
   *TagPtr += 1;
   Tag = *TagPtr;
   Set_Tag(FilHdr, Tag);
   Set_SCC(FilHdr, FilHdr);
   Set_Flag(FilHdr, FLAG_Elm);

   MinNameStatus = STAT_OK;
   Set_ElmNameStatus(FilHdr, MinNameStatus);
   MaxNameModDate = 1;
   Set_ElmNameModDate(FilHdr, MaxNameModDate);
   if (DataFlag) {
      MinStatus = STAT_OK;
      Set_ElmStatus(FilHdr, MinStatus);
      MaxModDate = 1;
      Set_ElmModDate(FilHdr, MaxModDate); }/*if*/;

   LocElm = FilHdr_LocElm(FilHdr);
   while (LocElm != 0) {
      FilElm = LocElm_FilElm(LocElm);
      ElmFilHdr = FilElm_FilHdr(FilElm);
      FORBIDDEN(ElmFilHdr == ERROR);

      CompoundFlag = IsRef(ElmFilHdr);

      if (DataFlag || CompoundFlag) {
	 if (!IsUpToDate(ElmFilHdr)) {
	    GetFile(SignalPtr, ElmFilHdr);
	    if (*SignalPtr != NIL) {
	       Ret_FilHdr(ElmFilHdr);
	       Ret_FilElm(FilElm);
	       goto done; }/*if*/;
            CompoundFlag = IsRef(ElmFilHdr); }/*if*/;

	 Status = FilHdr_Status(ElmFilHdr);
	 ModDate = FilHdr_ModDate(ElmFilHdr);
	 if (DataFlag) {
	    if (MinStatus > Status) MinStatus = Status;
	    if (MaxModDate < ModDate) MaxModDate = ModDate; }/*if*/;
	 if (CompoundFlag) {
	    if (MinNameStatus > Status) MinNameStatus = Status;
	    if (MaxNameModDate < ModDate) MaxNameModDate = ModDate;

	    if (FilHdr_Tag(ElmFilHdr) == 0 &&
		(DataFlag
		 ? !IsElmUpToDate(ElmFilHdr)
		 : !IsElmNameUpToDate(ElmFilHdr))) {
	       GetElms(SignalPtr, ElmFilHdr, DataFlag, TagPtr);
	       if (*SignalPtr != NIL) {
		  Ret_FilHdr(ElmFilHdr);
		  Ret_FilElm(FilElm);
		  goto done; }/*if*/; }/*if*/;

	    if (FilHdr_Tag(ElmFilHdr) != 0) {
	       SCC_ElmFilHdr = FilHdr_SCC(ElmFilHdr);
	       FORBIDDEN(FilHdr_Flag(SCC_ElmFilHdr, FLAG_Elm) == 0);
	       if (Tag > FilHdr_Tag(SCC_ElmFilHdr)) {
		  Set_SCC(FilHdr, SCC_ElmFilHdr);
		  Tag = FilHdr_Tag(SCC_ElmFilHdr); }/*if*/;
	       Ret_FilHdr(SCC_ElmFilHdr); }/*if*/;

	    Status = FilHdr_ElmNameStatus(ElmFilHdr);
	    if (MinNameStatus > Status) MinNameStatus = Status;
	    ModDate = FilHdr_ElmNameModDate(ElmFilHdr);
	    if (MaxNameModDate < ModDate) MaxNameModDate = ModDate;

	    if (DataFlag) {
	       Status = FilHdr_ElmStatus(ElmFilHdr);
	       if (MinStatus > Status) MinStatus = Status;
	       ModDate = FilHdr_ElmModDate(ElmFilHdr);
	       if (MaxModDate < ModDate) MaxModDate = ModDate;
	       }/*if*/; }/*if*/; }/*if*/;

      Ret_FilHdr(ElmFilHdr);
      LocElm = FilElm_Next(FilElm);
      Ret_FilElm(FilElm); }/*while*/;

   /*select*/{
      if (Tag == *TagPtr) {
	 Set_ElmNameStatus(FilHdr, MinNameStatus);
	 Set_ElmNameModDate(FilHdr, MaxNameModDate);
	 if (DataFlag) {
	    Set_ElmStatus(FilHdr, MinStatus);
	    Set_ElmModDate(FilHdr, MaxModDate); }/*if*/;
      }else{
	 SCC_FilHdr = FilHdr_SCC(FilHdr);
	 if (MinNameStatus < FilHdr_ElmNameStatus(SCC_FilHdr)) {
	    Set_ElmNameStatus(SCC_FilHdr, MinNameStatus); }/*if*/;
	 if (MaxNameModDate > FilHdr_ElmNameModDate(SCC_FilHdr)) {
	    Set_ElmNameModDate(SCC_FilHdr, MaxNameModDate); }/*if*/;
	 if (DataFlag) {
	    if (MinStatus < FilHdr_ElmStatus(SCC_FilHdr)) {
	       Set_ElmStatus(SCC_FilHdr, MinStatus); }/*if*/;
	    if (MaxModDate > FilHdr_ElmModDate(SCC_FilHdr)) {
	       Set_ElmModDate(SCC_FilHdr, MaxModDate); }/*if*/; }/*if*/;
	 Ret_FilHdr(SCC_FilHdr); };}/*select*/;

done:;
   Clr_Flag(FilHdr, FLAG_Elm);
   SCC_FilHdr = FilHdr_SCC(FilHdr);
   if (FilHdr == SCC_FilHdr) {
      ClearSCC(FilHdr, DataFlag, (*SignalPtr != NIL)); }/*if*/;
   Ret_FilHdr(SCC_FilHdr);
   }/*GetElms*/;


ClearSCC(FilHdr, DataFlag, Abort)
   tp_FilHdr FilHdr;
   boolean DataFlag;
   boolean Abort;
{
   tp_LocElm LocElm;
   tp_FilElm FilElm;
   tp_FilHdr SCC_FilHdr, ElmFilHdr;

   if (FilHdr_Tag(FilHdr) == 0) {
      return; }/*if*/;
   Set_Tag(FilHdr, 0);

   /*select*/{
      if (Abort) {
	 Set_ElmNameStatus(FilHdr, STAT_Unknown);
	 Set_ElmStatus(FilHdr, STAT_Unknown);
      }else{
	 SCC_FilHdr = FilHdr_SCC(FilHdr);
	 Set_ElmNameStatus(FilHdr, FilHdr_ElmNameStatus(SCC_FilHdr));
	 Set_ElmNameModDate(FilHdr, FilHdr_ElmNameModDate(SCC_FilHdr));
	 Set_ElmNameConfirmDate(FilHdr);
	 if (DataFlag) {
	    Set_ElmStatus(FilHdr, FilHdr_ElmStatus(SCC_FilHdr));
	    Set_ElmModDate(FilHdr, FilHdr_ElmModDate(SCC_FilHdr));
	    Set_ElmConfirmDate(FilHdr); }/*if*/;
	 Ret_FilHdr(SCC_FilHdr); };}/*select*/;


   LocElm = FilHdr_LocElm(FilHdr);
   while (LocElm != 0) {
      FilElm = LocElm_FilElm(LocElm);
      ElmFilHdr = FilElm_FilHdr(FilElm);
      FORBIDDEN(ElmFilHdr == ERROR);
      ClearSCC(ElmFilHdr, DataFlag, Abort);
      Ret_FilHdr(ElmFilHdr);
      LocElm = FilElm_Next(FilElm);
      Ret_FilElm(FilElm); }/*while*/;

   Set_SCC(FilHdr, (tp_FilHdr)NIL);
   }/*ClearSCC*/;


/*private*/ tp_Status
Get_ToolStatus(Tool, DepStatus)
   tp_Tool Tool;
   tp_Status DepStatus;
{
   tp_Status MinStatus;

   FORBIDDEN(DepStatus <= STAT_Unknown);

   switch (Tool_TClass(Tool)) {
      case TC_Browser: case TC_User: case TC_Hook:
      case TC_Compound: case TC_Name: case TC_Names:
      case TC_Homo: case TC_ImHo: case TC_DirElms:
      case TC_Label: case TC_Labels: case TC_Union:
      case TC_CopyCheck: case TC_Collect: case TC_CopyTest:
      case TC_Expand: case TC_CmdRef: case TC_ExpandHooks: {
	 MinStatus = ((DepStatus > STAT_Error) ? DepStatus : STAT_SysAbort);
	 break;}/*case*/;
      case TC_StructMem: {
	 /* to handle ErrOK structure members */
	 MinStatus = ((DepStatus == STAT_Error) ? STAT_Warning : DepStatus);
	 break;}/*case*/;
      case TC_DrvDirElm: {
	 MinStatus = DepStatus;
	 break;}/*case*/;
      case TC_Error: case TC_Warning: case TC_Depend: case TC_Sentinel:
      case TC_InternalPntr: {
	 MinStatus = STAT_OK;
	 break;}/*case*/;
      case TC_Cat: {
	 MinStatus = ((DepStatus > STAT_Error) ? DepStatus
		      :((DepStatus > STAT_SysAbort) ? STAT_Error
			: STAT_SysAbort));
	 break;}/*case*/;
      default: {
	 FatalError("illegal ToolClass"); };}/*switch*/;

   return MinStatus;
   }/*Get_ToolStatus*/;


