/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/Filename.h"
#include "inc/Str.h"
#include "inc/Status_.h"


int			History;
tp_FilDsc		HistoryFD;


Init_History()
{
   tps_FileName HistoryFileName;

   Get_HistoryFileName(HistoryFileName);
   HistoryFD = FileName_RWFilDsc(HistoryFileName);
   History = 5;
   }/*Init_History*/;


Close_History()
{
   Close(HistoryFD);
   }/*Close_History*/;


Set_History(NewHistory)
   int NewHistory;
{
   if (NewHistory < 0) {
      Writeln(StdOutFD, "** History count must be positive **");
      return; }/*if*/;
   History = NewHistory;
   }/*Set_History*/;


PrintHistory()
{
   int Count;
   tp_Str Str;
   tps_Str StrBuf;

   Unwind(HistoryFD);
   Str = BackReadLine(StrBuf, HistoryFD);
   Count = 1;
   while (Str != ERROR && Count < History) {
      Str = BackReadLine(StrBuf, HistoryFD);
      Count += 1; }/*while*/;
   if (Str == ERROR) Count -= 1;
   while (Count > 0) {
      Write(StdOutFD, "<> ");
      Str = ReadLine(StrBuf, HistoryFD);
      Writeln(StdOutFD, Str);
      Count -= 1; }/*while*/;
   }/*PrintHistory*/;


EditHistory()
{
   tps_Str CmdStr;
   tps_FileName HistoryFileName;

   Get_HistoryFileName(HistoryFileName);
   Close(HistoryFD);
   (void) strcpy(CmdStr, EditorName);
   (void) strcat(CmdStr, " ");
   (void) strcat(CmdStr, HistoryFileName);
   (void) system(CmdStr);
   HistoryFD = FileName_RWFilDsc(HistoryFileName);
   PrintHistory();
   }/*EditHistory*/;


CopyToHistory(SignalPtr, Root)
   tp_Signal *SignalPtr;
   tp_Nod Root;
{
   tp_PrmFHdr PrmFHdr;
   tp_FilHdr FilHdr;
   tp_Prms Prms;
   tp_Status Status;
   tps_FileName FileName;
   tp_FilDsc FilDsc;

   if (Root == ERROR) return;

   PrmFHdr = Nod_PrmFHdr(Nod_Son(1, Root));
   Use_PrmFHdr(&FilHdr, &Prms, PrmFHdr);
   if (FilHdr == ERROR) {
      goto done; }/*if*/;
   GetAllReqs(SignalPtr, FilHdr);
   if (*SignalPtr != NIL) {
      goto done; }/*if*/;
   Status = FilHdr_MinStatus(FilHdr);
   if (Status <= STAT_Error) {
      ReportStatus(FilHdr);
      goto done; }/*if*/;

   FilHdr_DataFileName(FileName, FilHdr);
   FilDsc = FileName_RFilDsc(FileName);
   Unwind(HistoryFD);
   FileCopy(HistoryFD, FilDsc);

done:
   Ret_FilHdr(FilHdr);
   }/*CopyToHistory*/;


/*private*/ tp_Str
Get_HistEntry(StrBuf, SearchStr)
   tp_Str StrBuf;
   tp_Str SearchStr;
{
   int EntryNum, i, Count;
   tp_Str Str;

   EntryNum = atoi(SearchStr);
   if (EntryNum > History) {
      return ERROR; }/*if*/;
   Unwind(HistoryFD);
   if (EntryNum > 0) {
      for (i=0; i<EntryNum; i++) Str = BackReadLine(StrBuf, HistoryFD);
      return Str; }/*if*/;
   Str = BackReadLine(StrBuf, HistoryFD);
   Count = 0;
   while (Str != ERROR && Count < History) {
      if (Is_SubWord(SearchStr, Str)) {
	 return Str; }/*if*/;
      Str = BackReadLine(StrBuf, HistoryFD);
      Count += 1; }/*while*/;
   return ERROR;
   }/*Get_HistEntry*/;


DoHistEntry(Root)
   tp_Nod Root;
{
   tps_Str EntryBuf;
   tp_Str SearchStr, Entry;
   tp_Signal Signal;

   SearchStr = Sym_Str(Nod_Sym(Nod_Son(1, Root)));
   Entry = Get_HistEntry(EntryBuf, SearchStr);
   if (Entry == ERROR) {
      SystemError(SystemErrorFD(), "Entry <%s> not found.\n", SearchStr);
      return; }/*if*/;
   Write(StdOutFD, "<> ");
   Writeln(StdOutFD, Entry);
   CommandInterpreter(&Signal, Entry);
   }/*DoHistEntry*/;


EditHistEntry(Root)
   tp_Nod Root;
{
   tps_Str EntryBuf, CmdStr;
   tp_Str SearchStr, Entry;
   tps_FileName TmpFileName;
   int OldModTime;
   tp_FilDsc FilDsc;
   tp_Signal Signal;

   SearchStr = Sym_Str(Nod_Sym(Nod_Son(1, Root)));
   Entry = Get_HistEntry(EntryBuf, SearchStr);
   if (Entry == ERROR) {
      SystemError(SystemErrorFD(), "Entry <%s> not found.\n", SearchStr);
      return; }/*if*/;
   Get_TmpFileName(TmpFileName);
   FilDsc = FileName_WFilDsc(TmpFileName);
   Writeln(FilDsc, Entry);
   Close(FilDsc);
   OldModTime = ModTime(TmpFileName);
   (void)strcpy(CmdStr, EditorName);
   (void)strcat(CmdStr, " ");
   (void)strcat(CmdStr, TmpFileName);
   (void)system(CmdStr);
   if (ModTime(TmpFileName) != OldModTime) {
      FilDsc = FileName_RFilDsc(TmpFileName);
      Entry = ReadLine(EntryBuf, FilDsc);
      Close(FilDsc);
      Write(StdOutFD, "<> ");
      Writeln(StdOutFD, Entry);
      CommandInterpreter(&Signal, Entry); }/*if*/;
   Ret_TmpFileName(TmpFileName);
   }/*EditHistEntry*/;


AddHistEntry(Str)
   tp_Str Str;
{
   Unwind(HistoryFD);
   Writeln(HistoryFD, Str);
   }/*AddHistEntry*/;


