/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/FKind_.h"
#include "inc/Inputs.h"
#include "inc/Outputs.h"
#include "inc/RunSpc.h"


tp_Tool
FilHdr_Tool(FilHdr)
   tp_FilHdr FilHdr;
{
   tp_Tool Tool;

   switch (FilHdr_FKind(FilHdr)) {
      case FK_Src: case FK_Link: case FK_User: {
	 Tool = FilTyp_Tool(FilHdr_FilTyp(FilHdr));
	 break;}/*case*/;
      case FK_DrvDirElm: {
	 Tool = DrvDirElmTool;
	 break;}/*case*/;
      case FK_Homo: {
	 Tool = HomoTool;
	 break;}/*case*/;
      case FK_ImHo: case FK_PntrHo: {
	 Tool = ImHoTool;
	 break;}/*case*/;
      case FK_RplPntr: case FK_InpPntr: case FK_Instance: {
	 Tool = InternalPntrTool;
	 break;}/*case*/;
      case FK_DirElms: {
	 Tool = DirElmsTool;
	 break;}/*case*/;
      default: {
	 FatalError("Bad FKind"); };}/*switch*/;
   return Tool;
   }/*FilHdr_Tool*/;


FilHdr_RunSpc(RunSpc, FilHdr)
   tp_RunSpc RunSpc;
   tp_FilHdr FilHdr;
{
   tp_FilHdr TmpFilHdr, CheckFilHdr, InpFilHdr;
   tp_Prms Prms;
   tp_LocInp LocInp;
   tp_FilInp FilInp;
   tp_InpKind InpKind;
   tps_InpTyps InpTyps;
   tps_OutTyps OutTyps;
   int i;

   RunSpc->Prms = FilHdr_Prms(FilHdr);
   RunSpc->FilHdr = Copy_FilHdr(FilHdr);

   switch (FilHdr_FKind(FilHdr)) {
      case FK_User: {
	 GetInpTyps(FilHdr_FilTyp(FilHdr), InpTyps, &RunSpc->NumInps);
	 break;}/*case*/;
      case FK_DrvDirElm: case FK_Homo: case FK_ImHo: case FK_PntrHo: case FK_DirElms: {
	 RunSpc->NumInps = 1;
	 break;}/*case*/;
      case FK_RplPntr: case FK_InpPntr: case FK_Instance: {
	 RunSpc->NumInps = 0;
	 break;}/*case*/;
      default: {
	 FatalError("Bad FKind"); };}/*switch*/;
   LocInp = FilHdr_LocInp(FilHdr);
   for (i=0; i<RunSpc->NumInps; i++) {
      FORBIDDEN(LocInp == 0);
      FilInp = LocInp_FilInp(LocInp);
      InpFilHdr = FilInp_FilHdr(FilInp);
      InpKind = FilInp_InpKind(FilInp);
      if (!(InpKind_IsName(InpKind)
	    || InpKind_IsPntr(InpKind)
	    || IsGrouping_FilTyp(FilHdr_FilTyp(FilHdr))
	    )) {
	 Deref_Pntrs(&InpFilHdr, &Prms, InpFilHdr, FALSE);
	 RunSpc->Prms = Union_Prms(RunSpc->Prms, Prms); }/*if*/;
      FORBIDDEN(InpFilHdr == ERROR);
      RunSpc->InpFilHdrs[i] = InpFilHdr;
      LocInp = FilInp_Next(FilInp); Ret_FilInp(FilInp); }/*while*/;

   /*select*/{
      if (IsStruct(FilHdr)) {
	 GetOutTyps(FilHdr_FilTyp(FilHdr), OutTyps, &RunSpc->NumOuts);
	 for (i=0; i<RunSpc->NumOuts; i++) {
	    TmpFilHdr = Copy_FilHdr(FilHdr);
	    CheckFilHdr = FilHdr_CheckFilHdr(Copy_FilHdr(FilHdr));
	    if (CheckFilHdr != ERROR) TmpFilHdr = FilHdr_Head(TmpFilHdr);
	    TmpFilHdr = Do_Deriv(TmpFilHdr, DfltPrms, DfltPrms, OutTyps[i]);
	    if (CheckFilHdr != ERROR) {
	       TmpFilHdr = FilHdr_TestFilHdr(TmpFilHdr, CheckFilHdr);
	       Ret_FilHdr(CheckFilHdr); }/*if*/;
	    FORBIDDEN(TmpFilHdr == ERROR);
	    RunSpc->OutFilHdrs[i] = TmpFilHdr; }/*for*/;
      }else{
	 RunSpc->NumOuts = 1;
	 RunSpc->OutFilHdrs[0] = Copy_FilHdr(FilHdr);
	 };}/*select*/;
   }/*FilHdr_RunSpc*/;


Ret_RunSpc(RunSpc)
   tp_RunSpc RunSpc;
{
   int i;

   Ret_FilHdr(RunSpc->FilHdr);
   for (i=0; i<RunSpc->NumInps; i++) Ret_FilHdr(RunSpc->InpFilHdrs[i]);
   for (i=0; i<RunSpc->NumOuts; i++) Ret_FilHdr(RunSpc->OutFilHdrs[i]);
   }/*Ret_RunSpc*/;


