;; foreach module 
;; and other useful stuff
;; IE. General garbage module.
(defmodule forloop
  (standard) ()

  (defmacro foreach (dummy var in list do . forms)
    `(mapc (lambda (,var) ,@forms)
	   ,list))

  (export foreach)

  (defun show (object)
    (mapcar (lambda (slot-name)  (format t "~a: ~a\n" slot-name
					 (slot-value object slot-name)))
	    (mapcar slot-description-name
		    (class-slot-descriptions (class-of object)))))

  (defun rshow (x)
    (rshow-aux x ""))

  ;; same, but generic + recursive
  (defun rshow-aux (x st)
    (cond ((> (string-length st) 100)
	   (format t "..."))
	  (t (generic-rshow x st))))


  (defgeneric generic-rshow (ob st))

  (defmethod generic-rshow ((ob object) string)
    (print ob)
    (mapc (lambda (slot-name)
	      (format t "~a ~a:" string slot-name)
	      (rshow-aux (slot-value ob slot-name)
			 (string-append string "  ")))
	  (mapcar slot-description-name 
		  (class-slot-descriptions (class-of ob))))
    nil)

;;  (defmethod generic-rshow ((l pair) st)
;;     (format t "~a List: ~a\n" st (car l))
;;     (rshow-aux (car l) (string-append st "      "))
;;     (rshow-aux (cdr l) st))

  (defconstant Null (class-of nil))

;;  (defmethod generic-rshow ((a Null) st)
;;    nil)
		  

  (export show)
  (export rshow)
  
  (defun nth (n list)
    (cond ((= n 0) (car list))
	  (t (nth (- n 1) (cdr list)))))
  (export nth)

  (defun length (x)
    (cond ((null x)
	   0)
	  (t (+ 1 (length (cdr x))))))

  (export length)

  (defun min-list (x)
    (cond ((null (cdr x)) (car x))
	  (t (let ((min-rest (min-list (cdr x))))
	       (cond ((< (car x) min-rest)
		      (car x))
		     (t min-rest))))))
  (export min-list)
	      
  (defun minl (x . l)
    (min-aux x l))

  (defun min-aux (x l)
    (cond ((null l) x)
	  ((< x (car l))
	   (min-aux x (cdr l)))
	  (t (min-aux (car l) (cdr l)))))

  (defun maxl (x . l)
    (max-aux x l))

  (defun max-aux (x l)
    (cond ((null l) x)
	  ((> x (car l))
	   (max-aux x (cdr l)))
	  (t (max-aux  (car l) (cdr l)))))


  (export minl maxl)


  ;; Useful function not defined EulispLISP
  (defun deleq (a b)
    (cond
     ((null b) nil)
     ((eq a (car b))
      (cdr b))
     (t (cons (car b) (deleq a (cdr b)))) ))

  (export deleq)
	
  (defun map-all (fn lst)
    (cond ((null lst) nil)
	  ((atom lst) lst)
	  ((consp (car lst))
	   (cons (map-all fn (car lst))
		 (map-all fn (cdr lst))))
	  (t (cons (fn (car lst))
		   (map-all fn (cdr lst))))))

  (export map-all)

  (defun fold (fn lst init)
    (cond ((null lst) init)
	  (t (fold fn (cdr lst) 
		   (fn (car lst) init)))))
  (export fold)

  (defun mapvect (fn vect)
    (mapvect-aux fn (vector-length vect) (make-vector (vector-length vect) nil) vect))

  ;; work in RL direction (for peversity)
  (defun mapvect-aux (fn i new-v old-v)
    (cond ((zerop i) new-v)
	  (t ((setter vector-ref) new-v (- i 1) (fn (vector-ref old-v (- i 1))))
	     (mapvect-aux fn (- i 1) new-v old-v))))

  (export mapvect)

  (defmacro critical-code (dummy sem forms)
    `(progn (open-semaphore sem)
	    (let ((result (progn ,@forms)))
	      (close-semaphore sem)
	      result)))

  (export critical-code)

  (defun collect (p l)
    (cond ((null l) nil)
	  ((p (car l)) (cons (car l)
			     (collect p (cdr l))))
	  (t (collect p (cdr l)))))

  (export collect)
  ;; Only works  with 'eq' as comparator
  ;; Tidies a table by not copying 'nil' keys
;  (defmethod copy ((t1 table))
;    (let ((new-table (make-table eq)))
;      (mapc (lambda (x) 
;	      (cond ((table-ref t1 x)
;		     ((setter table-ref) new-table x
;		      (table-ref t1 x)))
;		    (t nil)))
;	    (table-keys t1))
;      new-table))
	       
;;  (defmacro <= (x y)    `(not (> ,x ,y)))
  
;  (defmacro >= (x y)    `(not (< ,x ,y)))
;  (export <= >=)

;;end module
  )
