(defmodule short-path2
  (standard0
   loopsII
   csp) ()

  ;; From Naff benchmarks ltd.

  (defun time (f) (let ((x (cpu-time)))
		    (f)
		    (- (cpu-time)
		       x)))

  (defun m1 () (main *weird-arcs* 6))

  ;; useful
  (defun delq (a lst)
    (delete a lst eq))

  (deflocal *terminator* -1)
  (deflocal *max-val* 1e20)
  
  ;; hmm
  (defun start-node (out-chans)
    (mapcar (lambda (x)
	      (OUT x 'set-parent))
	    out-chans)
    (mapcar (lambda (x) 'all-parents-set)
    (mapcar (lambda (x) 
	      (OUT x 0))
	    out-chans)
    (format t "Start Node: Terminators~%\n")
    (mapcar (lambda (x) (OUT x *terminator*))
	    out-chans)
    0)

  (defun internal-node (inputs outputs min-val)
    (cond ((null inputs)
	   (format t "I-Node terminating~%")
	   (mapcar (lambda (x) (OUT x *terminator*))
		   outputs)
	   min-val)
	  (t 
	   (IN-FROM (input val) inputs
		    (cond ((= val *terminator*)
			   (internal-node (delq input inputs) outputs min-val))
			  ((< val min-val)
			   (mapc (lambda (x) (OUT x val))
				 outputs)
			   (internal-node inputs outputs val))
			  (t (internal-node inputs outputs min-val)))))))

  (defun dest-node (inputs output min-val)
    (cond ((null inputs)
	   (OUT output min-val)
	   min-val)
	  (t (IN-FROM (input val) inputs
		      (cond ((= val *terminator*)
			     (dest-node (delq input inputs) output min-val))
			    ((< val min-val)
			     (dest-node inputs output val))
			    (t (dest-node inputs output min-val)))))))

  (defun arc (in out length)
    (let ((val (IN in)))
      (cond ((= val *terminator*) 
	     (OUT out *terminator*)
	     length)
	    (t (OUT out (+ val length))
	       (arc in out length)))))
			
  (defun result-printer (input)
    (let ((x (IN input)))
      (format t  "**Result is: ~a~%" x)
      x))


  (deflocal n-nodes 6)
  (deflocal *simple-arcs* '((0 1 1) (0 2 1)
			    (1 3 1) (1 4 1)
			    (2 3 1) (2 4 1)
			    (3 5 1) (4 5 1)))
		   
  (deflocal *weird-arcs* '((0 1 1) (0 2 2) (0 5 10)
			   (1 3 2) (1 4 4)
			   (2 3 2) (2 4 1) 
			   (3 5 2) (4 5 4)))

  ;; make things readable...
  (defun node-in-chan (arc)
    (cadr arc))
  (defun node-out-chan (arc)
    (caddr arc))
  (defun in-node (arc)
    (caar arc))
  (defun out-node (arc)
    (cadar arc))
  (defun arc-length (arc)
    (caddar arc))
    
  (defun main (arcs n-nodes)
    (let ((arc-chans (mapcar (lambda (arc)
			       (list  arc (make-Channel) (make-Channel)))
			     arcs))
	  (result-chan (make-Channel)))
      (PAR (FOR (arc-list arc-chans) arc-list
		(setq arc-list (cdr arc-list))
		(format t "Starting arc: ~a\n" (car arc-list))
		(arc (connect-channel-input (node-out-chan (car arc-list)))
		     (connect-channel-output (node-in-chan (car arc-list)))
		     (arc-length (car arc-list))))
	   (start-node
	    (mapcar (lambda (x) 
		      (connect-channel-output (node-out-chan x)))
		    (collect (lambda (arc-data)
			       (cond ((= (in-node arc-data) 0)
				      arc-data)
				     (t nil)))
			     arc-chans)))
	   (FOR (i 1) (< i (- n-nodes 1)) (++ i)
		(internal-node
		 (mapcar (lambda (x) 
			   (connect-channel-input (node-in-chan x)))
			 (collect (lambda (arc-data)
				    (cond ((= (out-node arc-data) i)
					   arc-data)
					  (t nil)))
				  arc-chans))
		 (mapcar (lambda (x) 
			   (connect-channel-output (node-out-chan x)))
			 (collect (lambda (arc-data)
				    (cond ((= (in-node arc-data) i)
					   arc-data)
					  (t nil)))
				  arc-chans))
		 *max-val*))
	   (dest-node 
	    (mapcar (lambda (arc-data)
		      (connect-channel-input (node-in-chan arc-data)))
		    (collect (lambda (arc-data)
			       (cond ((= (out-node arc-data)
					 (- n-nodes 1))
				      arc-data)
				     (t nil)))
			     arc-chans))
	    (connect-channel-output result-chan)
	    *max-val*)
	   (result-printer (connect-channel-input result-chan)))))
  
  )
