;; virtual pages, allocators, and so on.

(defmodule page-mapper
   (standard0
    low-dvsm
    page)
   
   ()
   (expose low-dvsm)

   (defconstant *max-pages* 16)

  (defstruct page-mapper ()
     ;; should really use a small vector and hash
     ((map initform (make-table eq)
	   accessor page-mapper-map))
     constructor (make-page-mapper))
  
  (export page-mapper)

  (defstruct page-info ()
     ((status initform 'unmapped
	      accessor page-info-status)
      (value initform ()
	     accessor page-info-value))
     constructor (make-page-info))
  ;; so we allocate the right sort of info

  (defgeneric mapper-info-class (mapper))
  (export page-info mapper-info-class)


  (defstruct virtual-page ()
     ((page-id initarg id 
	       reader virtual-page-id)
      ;; should be stored by the class?
      (mapper initarg mapper
	      reader virtual-page-mapper))
     constructor (make-virtual-page mapper id))

  ;; extracting information

  (defgeneric get-page-info (mapper id))
  (export get-page-info)

  ;; protocol to handle faults 

  (defgeneric map-page-read ((mapper id))
  (defgeneric map-page-write (mapper id))

  ;; standard method --- all extensions should be after.
  ;; It returns nil if it can't find the page.

  (defmethod map-page-read ((mapper page-mapper) id)
    (table-ref (page-mapper-map mapper) id))

  (export map-page-read map-page-write)

  ;; addresses and the like
  (defstruct address ()
     ((location initarg loc
		reader address-location)
      (page initarg page
	    reader address-page)
      (class initarg class
	     reader address-class))
     constructor (make-address loc page class))

  (export make-address address)
  
  (defstruct forward-addr ()
     ((location initform loc
		reader forward-location)
      (page initform page
	    reader forward-page))
     constructor (make-forward-addr loc page)
     predicate fwd-p)

  (defmethod address-ref (address offset)
    (let ((addr (prune-address address)))
      (real-address-ref addr offset)))

  (defmethod (setter address-ref) (address offset value)
    (let ((addr (prune-address address)))
      ((setter real-address-ref) address offset value)))

  (export address address-class address-page address-location)

  (defun prune-address (addr)
    addr)

  (defun real-address-ref (address offset)
    (page-ref (address-page address)
	      (address-location address)
	      offset))

  ((setter setter) real-address-ref 
   (lambda (addr off val) ((setter page-ref)
			   (address-page addr)
			   (address-location addr)
			   off val)))
  ;; virtual pages...
  (defmethod page-ref ((page virtual-page) loc offset)
    (let ((poss-page (grab-page (virtual-page-mapper page) 
			   (virtual-page-loc page))))
      (if (eq (page-id poss-page)
	      (virtual-page-id poss-page))
	  (page-ref poss-page loc offset)
	(page-ref (map-page-read (virtual-page-mapper page)
				 (virtual-page-id page))
		  loc offset))))

  (defmethod (setter page-ref) ((page virtual-page) loc offset value)
    ((setter page-ref) 
     (map-page-write (virtual-page-mapper page)
		     (virtual-page-id page))
     loc offset value))
)

