;; defines generics used everywhere in comm system

(defmodule comm-low
  (standard0)
  ()

  ;; sundry generics
  (defgeneric killed-p (ob)
    methods ((((o object))
	      nil)))
  (defgeneric deactivate-object (ob))
    
  ;; returns something unique to
  ;; the local host
  (defgeneric obj-id (obj))

  ;; local id (unique per eulisp job)
  (defconstant *local-id* (make-symbol (format nil "~a-~a" (getenv "HOST") (process-id))))

  (defun local-id ()
    *local-id*)


  (export local-id obj-id killed-p deactivate-object)
  
  ;; destroying resources 

  (defgeneric kill-object (obj))
  (export kill-object)
  ;; methods on encodeing are via
  ;; generic-encode
  ;; (setter *decoder)
  ;;
  ;;; to use
  ;; encode decode

  ;; encoding is expected to return a list...

  (defgeneric generic-encode (obj)
    methods ((((o object))
	      o)))

  (defun encode (obj)
    (generic-encode obj))

  ;;decoding.. uses a table lookup

  (deflocal *std-decoder* (make-table eq))
  
  (defun decode (ob)
    (if (consp ob)
	((*decoder (car ob)) ob)
      ob))

  ;; if no way of converting it, just return the object.

  (defun *decoder (name)
    (or (table-ref *std-decoder* name)
	(lambda (x) x)))

  ((setter setter) *decoder 
   (lambda (name fn)
     ((setter table-ref) *std-decoder* name fn)))

  (export encode *decoder decode generic-encode)
  
  ;;
  ;; sending messages 
  ;;

  (defgeneric recv-msg (connection))
  (defgeneric readable-p (connection))
  (defgeneric send-msg (connection msg))
  
  (export recv-msg readable-p send-msg)
  ;;
  ;; replying to messages
  ;;
  
  (defgeneric find-waiter (ob))
  (defgeneric waiter-restart (ob id result))
  
  (defconstant *reply-sym* '_<--_)

  (export find-waiter waiter-restart *reply-sym*)
)
