;; Eulisp Module
;; Author: pete broadbery
;; File: pvm-msgs.em
;; Date: 21/may/1991
;;
;; Project:
;; Description: 
;; message handlers for pvm-clients
;;

(defmodule pvm-msgs 
  (standard0
   list-fns
   waiters
   comm-low
   pvm-client
   )
  ()


  ;;
  ;; mesage handling
  ;;
  (defconstant find-pvm-message (mk-finder))

  (defmethod find-msg-handler ((cl pvm-client) msg)
    (or (find-pvm-message (car msg))
	(call-next-method)))
  
  (defmethod (setter find-msg-handler) ((cl pvm-client) ob fn)
    ((setter find-pvm-message) ob fn))

  (defmethod dispatch ((cl pvm-client))
    (wait-for-msg cl)
    (thread-start (make-thread 
		   (lambda ()
		     (dispatch-message cl (recv-msg cl)))))
    cl)
		    
;;  (defmethod read-messages ((cl pvm-client))
;;    (if (readable-p cl)
;;	(list (recv-msg cl))
;;      (format t "Whoops...~a~%" cl)))

  ;;
  ;; messages
  ;;

  ;; message is: client-name  address
  (defconstant *new-client* '%-new-client-%)

  (defun handle-new-client (client msg)
    (let ((client-names (cadr msg))
	  (client-ports (mapcar decode (caddr msg))))
      (mapcar (lambda (name port)
		(resend-client client name port)) 
	      client-names
	      client-ports)))


  (defun resend-client (client name new-client)
    (format (standard-error-stream)
	    "New client: ~a [~a]~%"
	    name new-client)
    (if (add-client client name new-client)
	;;(format t "Already known...~%")
	()
      (broadcast-new-client client name new-client)))

  (defun broadcast-new-client (client name new-client)
    (let ((all-clients (all-known-clients client)))
      (client-send-by-id client new-client
		      (list *new-client* 
			    (car all-clients)
			    (mapcar encode
				    (cadr all-clients))))
      (mapcar (lambda (cl)
		(client-send-by-id client 
				new-client
				(list *new-client* 
				      (list name)
				      (list (encode new-client)))))
	      (cadr all-clients))))

  (defun initiate-client (old new)
    (client-send-by-id old 
		       new
		       (list *new-client*
			     (list (obj-id old))
			     (list (encode (pvm-client-self old))))))
		     
  (export initiate-client)

  ;;
  ;; adding aquaintances
  ;; msg is: name object
  (defconstant *set-aq-ref* '%-set-aq-%)
  (defconstant *aq-ref* '%-aq-%)

  (defun handle-add-aquaintance (client msg)
    (let ((name (cadr msg))
	  (obj (caddr msg)))
      ((setter (client-aqs client)) name obj)))

  ;; message is: dest id name
  (defun handle-query-aquaintance (client msg)
    (let ((name (cadddr msg))
	  (dest (cadr msg))
	  (id (caddr msg)))
      (client-reply-msg client name id 
			((client-aqs client) name))))

  (defmethod client-aq-ref ((rc remote-pvm-client) name)
    (let ((id (get-next-id (find-waiter rc))))
      (send-msg rc  (list *aq-ref*
			  (make-reply-dest rc) 
			  id name))
      (decode (wait-on-id (find-waiter rc) id))))

  (defmethod (setter client-aq-ref) ((rc remote-pvm-client) name value)
    (send-msg rc (list *set-aq-ref* name (encode value))))
  
  ((setter find-pvm-message) *set-aq-ref* handle-query-aquaintance)

  ;; tell the world about myself

  ((setter find-pvm-message) *new-client* 
   handle-new-client)

  ;; replies: (symbol result)
  (defun handle-reply (client msg)
    (restart-waiter (find-waiter client)
		    (cadr msg)
		    (caddr msg)))

  ((setter find-pvm-message) *reply-sym* handle-reply)

  ;; send a reply message
  (defun client-reply-msg (client target id result)
    (send-msg-to client target
		 (list *reply-sym* id result)))
  
  (export client-reply-msg)
  ;; end module
  )
