; tail recursive loops
; uses dynamic (in catch/throw) and multiple values

(defmodule loops

  (standard) ()

  ()

  (defun map-while (ff pf val)
    (multiple-value-bind
     (ans cont)
     (catch @cc@ (map-while-cont ff pf val))
     (if cont
	 (map-while ff pf val)
         ans)))

  (defun map-while-cont (ff pf val)
    (if (pf)
	(map-while-cont ff pf (ff))
        (values val ())))

  (defmacro break forms
    `(throw @bc@ (progn ,@forms)))

  (defmacro continue ()
    `(throw @cc@ (values () t)))

  (defmacro while (pred . forms)
    `(catch @bc@
       (map-while (lambda () ,@forms)
		  (lambda () ,pred)
		  ())))

  (defmacro for (init test iter . body)
    `(progn
       ,init
       (catch @bc@
	  (map-for (lambda () ,@body)
		   (lambda () ,test)
		   (lambda () ,iter)
		   ()))))

  (defun map-for (ff pf itf val)
    (if (pf)
	(multiple-value-bind
	  (ans cont)
	  (catch @cc@ (map-for-cont ff pf itf (ff)))
	  (if cont
	      (progn (itf) (map-for ff pf itf val))
	      ans))
        val))

  (defun map-for-cont (ff pf itf val)
    (itf)
    (if (pf)
	(map-for-cont ff pf itf (ff))
        (values val ())))

  (export map-while while map-for for break continue)

)
