(defmodule namespaces (standard0) ()

  ;
  ;; Structure
  ;

  (defstruct name-space ()
    ((binding-table 
       initform (make-table eq)
       reader name-space-binding-table))
    constructor make-name-space)

  (export name-space make-name-space)

  ;
  ;; Functionality
  ;

  (defgeneric name-space-ref (space name))

  (defgeneric set-name-space-ref (space name value))

  ((setter setter) name-space-ref set-name-space-ref)

  (export name-space-ref)

  ;
  ;; Default methods
  ;

  (defmethod name-space-ref ((space name-space) (name symbol))
    (table-ref (name-space-binding-table space) name))

  (defmethod (setter name-space-ref) ((space name-space) (name symbol) val)
    ((setter table-ref) (name-space-binding-table space) name val))

  ;
  ;; Syntax
  ;

  (defmacro def-name-space (name)
    `(defconstant ,name (make-name-space)))

  (defmacro export-to-name-space (space . key-list)
    (labels
      ((map-key-list (fn kl)
	 (cond ((null kl) ()) 
	       ((null (cdr kl)) ()) ; Should signal an error
	       (t (cons (fn (car kl) (car (cdr kl))) 
			(map-key-list fn (cdr (cdr kl))))))))
      `(progn
	 ,@(map-key-list
	     (lambda (key val)
	       `((setter name-space-ref) ,space ',key ,val))
	     key-list))))

  (export def-name-space export-to-name-space)

)

