;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                           ;;
;;  EuLisp Module                     Copyright (C) University of Bath 1991  ;;
;;                                                                           ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defmodule net-polly

  (lists
   list-operators
   extras
   streams
   others
   formatted-io
   sockets
   arith
   vectors
   tables
   ccc) ()

  (deflocal local-display (getenv "DISPLAY"))

  (deflocal x-vert 5)
  
  (defun run-remote-string (exp host)
    (format nil 
	    "rsh ~a xterm -display ~a -g 80x10-5+~a -e 'feel -do \"~a\"' & \n"
	    host local-display x-vert exp))
    
  (defun run-remote (exp host)
    (let ((str (run-remote-string exp host)))
      (setq x-vert (+ x-vert 120))
      (system str)
      str))

  (deflocal my-listener (make-listener))

  (deflocal my-listener-id (listener-id my-listener))

  (deflocal hosts '(brad janet))

  (deflocal host-table (make-table eq))

  (defun host-boot (host)
    (run-remote 
      `(progn 
	 (load-module net-p-c) 
	 (start-module net-p-c run-client ',my-listener-id ',host))
      host)
    host)

  (defun prepare-hosts () 
    (format t "Booting hosts...\n")
    (boot-hosts hosts)
    (format t "Connecting to hosts...\n")
    (contact-hosts hosts)
    (format t "Done.\n"))

  (defun boot-hosts (hosts)
    (if (null hosts) nil
      (progn
	(host-boot (car hosts))
	(boot-hosts (cdr hosts)))))

  (defun contact-hosts (hosts)
    (if (null hosts) nil
      (let* ((s (listen my-listener))
	     (h (socket-read s)))
	((setter table-ref) host-table h s)
	(contact-hosts (cdr hosts)))))

  (defun prepare-hosts-aux (hl)
    (if (null hl) nil
      (progn
	((setter table-ref) host-table (car hl) (host-connect (car hl)))
	(prepare-hosts-aux (cdr hl)))))

  (defun write-to-host (host exp)
    (socket-write (table-ref host-table host) exp))

  (defun read-from-host (host)
    (socket-read (table-ref host-table host)))

  (defun remote-thing(r1 r2 host thing)
    (write-to-host host thing)
    (write-to-host host r1)
    (write-to-host host r2)
    (read-from-host host))

  (defun remote-plus (r1 r2 host) (remote-thing r1 r2 host 'plus))

  (defun remote-minus (r1 r2 host) (remote-thing r1 r2 host 'minus))

  (defun remote-times (r1 r2 host) (remote-thing r1 r2 host 'times))

  (defun remote-close (host) (write-to-host host 'stop))

  (defun remote-close-all () (remote-close-all-aux hosts))

  (defun remote-close-all-aux (hosts)
    (if (null hosts) (format t "All hosts closed\n")
      (progn
	(remote-close (car hosts))
	(remote-close-all-aux (cdr hosts)))))

  (setq r1 '(((x . 2) . 1)))

  (setq r2 '(((x . 1) . 1) . 1))

)

