;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                           ;;
;;  EuLisp Module                     Copyright (C) University of Bath 1991  ;;
;;                                                                           ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defmodule scheme

  (standard) ()

  ;; Extra special forms...

  (defmacro define (bind . values)
    (if (consp bind) 
	(let ((name (car bind))
	      (args (cdr bind)))
	  (if (symbolp name) 
	      `(deflocal ,name (lambda ,args ,@ values))
	      (error "define: bad syntax" clock-tick)))
        (if (symbolp bind) 
	    `(deflocal ,bind ,(car values))
	     (error "define: bad identifier" clock-tick))))

  (defmacro set! (bind val) `(setq ,bind ,val))

  (export define set!)

  ;; Arith ops...

  (export + - * / remainder)

  ;; Comparitors

  (export < > =)

  ;; Conditionals...

  (defconstant else t) ;; A Hack

  (export cond else)

  ;; Combinations...

  (export or and not)

  ;; Extentions...

  (export let)

  ;; Predicates...

  (defun atom? (x) (not (consp x)))
  (defun pair? (x) (consp x))
  (defun symbol? (x) (symbolp x))
  (defun number? (x) (numberp x))

  (export atom? symbol? number?)

)


  
