;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                           ;;
;;  EuLisp Module                     Copyright (C) University of Bath 1991  ;;
;;                                                                           ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defmodule setf

  (standard0) ()

  (defmacro ++ (form . vals)
    (cond ((atom form)
	   `(setq ,form (+ ,form 1)))
	  ((eq (car form) 'dynamic)
	   `(dynamic-setq ,(cadr form) (+ ,form 1)))
	  (t
	   `((setter ,(car form)) ,(cadr form) (+ ,form 1)))))	     

  (defmacro -- (form)
    (cond ((atom form)
	   `(setq ,form (- ,form 1)))
	  ((eq (car form) 'dynamic)
	   `(dynamic-setq ,(cadr form) (- ,form 1)))
	  (t
	   `((setter ,(car form)) ,(cadr form) (- ,form 1)))))	     

  (export ++ --)

  (defmacro setf (form val)
    (cond ((atom form)
	   `(setq ,form ,val))
	  ((eq (car form) 'dynamic)
	   `(dynamic-setq ,(cadr form) ,val))
	  (t
           `(let ((@-woo-woo-@ ,val))
	      ((setter ,(car form)) ,@(cdr form) @-woo-woo-@)
	      @-woo-woo-@))))

  (export setf)

)
