(defmodule while
  (lists macros0 extras0 others list-operators ccc) ()

  (defun map-while (ff pf) 
    (if (pf) (progn (ff) (map-while ff pf)) nil))

  (defmacro while (pred . forms)
    `(map-while (lambda () (progn ,@forms)) (lambda () ,pred)))
  
  (defmacro ++ (form . vals)
    (cond ((atom form)
	   `(setq ,form (+ ,form 1)))
	  ((eq (car form) 'dynamic)
	   `(dynamic-setq ,(cadr form) (+ ,form 1)))
	  (t
	   `((setter ,(car form)) ,(cadr form) (+ ,form 1)))))	     

  (defmacro -- (form)
    (cond ((atom form)
	   `(setq ,form (- ,form 1)))
	  ((eq (car form) 'dynamic)
	   `(dynamic-setq ,(cadr form) (- ,form 1)))
	  (t
	   `((setter ,(car form)) ,(cadr form) (- ,form 1)))))	     

  (export map-while while ++ --)

)
