/* ******************************************************************** */
/*  class.h          Copyright (C) Codemist and University of Bath 1989 */
/*                                                                      */
/* Class fun prototypes                                                 */
/* ******************************************************************** */

#define CLASS_KEY(class) class /* The bit of a class used for key tables */

/* Class object accessors... */

extern LispObject Fn_classp(LispObject*);
extern LispObject Fn_class_of(LispObject*);
extern LispObject Fn_subclassp(LispObject*);
extern LispObject Fn_class_name(LispObject*);
extern LispObject Fn_class_precedence_list(LispObject*);
extern LispObject Fn_class_direct_superclasses(LispObject*);
extern LispObject Fn_local_slots(LispObject*);
extern LispObject Fn_class_slot_descriptions(LispObject*);
extern LispObject Fn_class_direct_superclasses(LispObject*);
extern LispObject Fn_class_direct_subclasses(LispObject*);
extern LispObject Fn_class_slot_descriptions(LispObject*);
extern LispObject Fn_class_direct_slot_descriptions(LispObject*);

/* Slot access protocol... */

extern LispObject make_instance(LispObject*,Env,LispObject,LispObject);

/* Slot read chain */

extern LispObject Fn_slot_value(LispObject*);
extern LispObject Gf_slot_description_reader;

/* Slot write chain */

extern LispObject Fn_slot_value_setter(LispObject*);

extern LispObject Fn_slot_description_readers(LispObject*);
extern LispObject Fn_slot_description_writers(LispObject*);

extern LispObject search_initargs(LispObject,LispObject);

extern LispObject defstruct(LispObject*,
			    LispObject,Env,LispObject,
			    LispObject,LispObject,LispObject);

extern LispObject Fn_slot_exists_p(LispObject*);

extern LispObject Fn_nconc(LispObject*);

extern LispObject Fn_make_constructor(LispObject*);
extern LispObject Fn_make_reader(LispObject*);
extern LispObject Fn_make_writer(LispObject*);
 
/* GF prototypes */
extern LispObject Gf_allocate_instance;
extern LispObject Md_allocate_instance(LispObject*);

/* Utilities */
extern LispObject search_keylist(LispObject*,LispObject,LispObject);

/* Inheritance */

extern LispObject Fn_add_superclasses(LispObject*);
extern LispObject Fn_add_subclass(LispObject*);
extern LispObject Fn_metaclass_compatibility(LispObject*);
extern LispObject Fn_collect_slots(LispObject*);
extern LispObject Gf_make_slot_description(LispObject*);
extern LispObject Gf_make_inherited_slot_description(LispObject*);
extern LispObject Gf_make_instance(LispObject*);

extern LispObject Fn_inherit_slot_details(LispObject*);

extern LispObject Fn_shared_slot_description_reader(LispObject*);
extern LispObject Fn_shared_slot_description_writer(LispObject*);
extern LispObject eval_alternate(LispObject,Env,LispObject);

/* Symbols */

extern LispObject symbol_initargs;
extern LispObject symbol_initform;
extern LispObject symbol_metaclass;

/* Objects... */

extern LispObject generic_allocate_instance;
extern LispObject generic_initialize_instance;

