#include <stdio.h>

#include "structs.h"
#include "funcalls.h"
#include "defs.h"
#include "global.h"
#include "ngenerics.h"
#include "modules.h"
#include "bvf.h"
#include "allocate.h"
#include "modboot.h"

/* Definition of the bytecodes */  
#include "iset.h"

typedef unsigned char bytecode;
static LispObject ByteFunction_Class;
static LispObject ByteFunction;



static LispObject boot_modules[50];
static int boot_module_count=1;

static bytecode exit_bytes[] = { BC_EXIT };


static int static_count; static LispObject *statics[256]; static LispObject static_vectors[256];  static bytecode *bytevectors[256];  static int exec_counts[256];


static LispObject Cb_fn_return;


LispObject compute_and_apply_method();
LispObject call_method();
LispObject module_apply_args();


LispObject interpret_bytes(LispObject *stacktop, bytecode *start_pc, int context)
{
  
  LispObject BCtrue=lisptrue;
  LispObject BCnil=nil;
  LispObject BC_globals;
  bytecode *pc;
  LispObject *sp;
  int this_vector;

  
 BCnil=nil; 
 BCtrue=lisptrue; 
 ; 
 sp=stacktop-1;  
 pc=start_pc; 
 this_vector=context;;

  while (TRUE)
    {
       
 exec_counts[*pc]++;;
      switch(*(pc++))
	{
	  
	  
 case BC_NOP: 
 break;
	  
	  
	  
 case BC_PUSH_GLOBAL: 
 { 
 int i,j; 
 LispObject tmp; 
 
 i= (int)(*(pc++)); 
 i=(i<<8)+((int)(*(pc++))); 
 i=(i<<8)+((int)(*(pc++))); 
 i= *(pc++) ? -i: i; 
 ;; 
 j= (int)(*(pc++)); 
 j=(j<<8)+((int)(*(pc++))); 
 j=(j<<8)+((int)(*(pc++))); 
 j= *(pc++) ? -j: j; 
 ;; 
 (*(++sp)=statics[i][j]); 
 } break;
	  
 case BC_SET_GLOBAL: 
 { 
 int i,j; 
 
 i= (int)(*(pc++)); 
 i=(i<<8)+((int)(*(pc++))); 
 i=(i<<8)+((int)(*(pc++))); 
 i= *(pc++) ? -i: i; 
 ;; 
 j= (int)(*(pc++)); 
 j=(j<<8)+((int)(*(pc++))); 
 j=(j<<8)+((int)(*(pc++))); 
 j= *(pc++) ? -j: j; 
 ;; 
 statics[i][j] = (*(sp--)); 
 } break;
	  
 case BC_PUSH_STATIC: 
 { 
 int j; 
 LispObject tmp; 
 j= (int)(*(pc++)); 
 j=(j<<8)+((int)(*(pc++))); 
 j=(j<<8)+((int)(*(pc++))); 
 j= *(pc++) ? -j: j; 
 ;; 
 (*(++sp)=statics[this_vector][j]); 
 } break;
	  
 case BC_PUSH_FIXNUM: 
 { 
 int i; 
 LispObject tmp; 
 i= (int)(*(pc++)); 
 i=(i<<8)+((int)(*(pc++))); 
 i=(i<<8)+((int)(*(pc++))); 
 i= *(pc++) ? -i: i; 
 ;; 
 tmp=allocate_integer(sp+1,i); 
 (*(++sp)=tmp); 
 } break;
	  
 case BC_SET_STATIC: 
 { 
 int j; 
  
 j= (int)(*(pc++)); 
 j=(j<<8)+((int)(*(pc++))); 
 j=(j<<8)+((int)(*(pc++))); 
 j= *(pc++) ? -j: j; 
 ;; 
 statics[this_vector][j]=(*(sp--)); 
 } break;

	  
 case BC_PUSH_SPECIAL: 
 { 
 switch (*(pc++)) 
 { 
 case 0: 
 (*(++sp)=BCnil); 
 break; 
 
 case 1: 
 (*(++sp)=BCtrue); 
 break; 
 
 default: 
 fprintf(stderr,"odd special"); 
 (*(++sp)=BCnil); 
 break; 
 } 
 } break;

	  
	  
 case BC_PUSH_NTH: 
 { 
 int i; 
 LispObject tmp; 
 
 i = *(pc++);; 
  
 tmp=(*((sp)-(i))); 
 (*(++sp)=tmp); 
 } break;
	  
 case BC_SET_NTH: 
 { 
 int i; 
 
 
 i = *(pc++);; 
 
 (*((sp)-(i)))=(*(sp)); 
 ((sp) -= (1)); 
 } break;
	  
	  
	  
 case BC_SLIDE_STACK: 
 { 
 int depth,keep,n,counter; 
 
 
 depth = *(pc++);; 
 
 keep = *(pc++);; 
 sp-= depth; n=depth-keep; for (counter=0; counter<keep; counter++) { sp++; *sp=*(sp+n); } } break;
	  
 case BC_SWAP: 
 { 
 LispObject tmp; 
 
 tmp=*sp; 
 *sp = *(sp-1); 
 *(sp-1) = tmp; 
 } break;
	  
 case BC_DROP: 
 { 
 int i; 
 
 
 i = *(pc++); 
 ((sp) -= (i)); 
 } break;
	  
	  
	  
 case BC_ENV_REF: 
 { 
 int i,j,counter; 
 LispObject env=(*(sp)); 
 
 
 i = *(pc++);; 
 
 j = *(pc++);; 
 counter=i; while (counter) { env=vref(env,0); counter--; } env=vref(env,j+1);; 
 ((*(sp))=env); 
 } break;
	  
 case BC_SET_ENV: 
 { 
 int i,j,counter; 
 LispObject env; 
 LispObject val; 
 val=(*(sp--)); 
 env=(*(sp)); 
 
 
 i = *(pc++);; 
 
 j = *(pc++);; 
 counter=i; while (counter) { env=vref(env,0); counter--; } vref(env,j+1)=val;; 
 } break;
	  
 case BC_POP_ENV: 
 { 
 int i,counter; 
 LispObject env=(*(sp)); 
 
 
 i = *(pc++);; 
 counter=i; while (counter) { env=vref(env,0); counter--; }; 
 ((*(sp))=env); 
 } break;
	  
 case BC_MAKE_ENV: 
 { 
 int i; 
 
 
 i = *(pc++);; 
 
 { 
 LispObject tmp; 
  
 tmp=allocate_vector(sp+1, i+1); 
 vref(tmp,0)= (*(sp)); 
 ((*(sp))=tmp); 
 }; 
 { if (1) { BCnil=nil; BCtrue=lisptrue; } }; 
 } break;

	  
	  
 case BC_VREF: 
 { 
 LispObject tmp=(*(sp--)); 
  
 ((*(sp))=vref((*(sp)), 
 intval(tmp))); 
 } break;
	  
 case BC_SET_VREF: 
 { 
 LispObject val=(*(sp--)); 
 LispObject loc; 
 loc=(*(sp--)); 
  
 vref((*(sp)),intval(loc))=val; 
 ((*(sp))=val); 
 } break;
	  
 case BC_SLOT_REF: 
 { 
 LispObject obj=(*(sp)); 
 int i; 
  
 
 i = *(pc++);; 
 ((*(sp))=slotref(obj,i)); 
 } break;
	  
 case BC_SET_SLOT: 
 { 
 LispObject val; 
 LispObject obj; 
 int i; 
  
 val=(*(sp--)); 
 obj=(*(sp)); 
  
 
 i = *(pc++);; 
 slotref(obj,i)=val; 
 ((*(sp))=val); 
 } break;
	  
 case BC_SET_TYPE: 
 { 
 LispObject type; 
 type=(*(sp--)); 
  
 lval_typeof((*(sp)))=intval(type); 
 } break;
	  
	  
	  
 case BC_BRANCH: 
 { 
 int i; 
 bytecode *opc=pc; 
 
 i= (int)(*(pc++)); 
 i=(i<<8)+((int)(*(pc++))); 
 i=(i<<8)+((int)(*(pc++))); 
 i= *(pc++) ? -i: i; 
 ;; 
 pc=
 ((opc)+((i)-1)); 
 } break;
	  
 case BC_BRANCH_NIL: 
 { 
 int i; 
 
 if ((*(sp--))==BCnil) 
 { 
 bytecode *opc=pc; 
 i= (int)(*(pc++)); 
 i=(i<<8)+((int)(*(pc++))); 
 i=(i<<8)+((int)(*(pc++))); 
 i= *(pc++) ? -i: i; 
 ;; 
 pc=
 ((opc)+((i)-1)); 
 } 
 else 
 pc+=sizeof(int); 
 } break;

	  
	  
 case BC_APPLY_ANY: 
 { 
 int nargs,abs_args,real_args; 
 LispObject fn; 
 LispObject *arg_start; 
  
 nargs=(int)((char) *(pc++));; 
 abs_args=nargs<0? -nargs: nargs; 
 fn=(*(sp--)); 
  
 switch(typeof(fn)) 
 { 
 case TYPE_GENERIC: 
 { 
 LispObject ptr,*walker; 
 LispObject meths; 
 LispObject *arg_1; 
 int count; 
 
 arg_1=sp-nargs; 
 arg_1++; 
  
 ptr=CAR(generic_fast_method_cache(fn)); 
  
 if (ptr!=nil) 
 { 
  
 walker=arg_1; 
 count=0; 
 while (count<nargs && CAR(ptr)==classof(*(walker))) 
 { 
 ptr=CDR(ptr); 
 walker++; 
 count++; 
 } 
 
 if (count==nargs) 
 { 
 meths=CDR(generic_fast_method_cache(fn)); 
 goto call_method; 
 } 
 
  
 
 ptr=generic_slow_method_cache(fn); 
 walker=arg_1; 
 count=0; 
 
 while(ptr!=nil && count<nargs) 
 { 
 if (CAR(CAR(ptr))==classof(*(walker))) 
 {  
 ptr=CDR(CAR(ptr)); 
 walker++; 
 count++; 
 } 
 else 
 ptr=CDR(ptr); 
 } 
 
 if (count==nargs) 
 { 
 generic_fast_method_cache(fn)=ptr; 
 meths=CDR(ptr); 
 goto call_method; 
 } 
  
 } 
  
 
  
  
 { 
 LispObject res,args; 
 LispObject *stacktop=sp+1,*stackbase=arg_1; 
 STACK_TMP(fn); 
 args=allocate_n_conses(stacktop,nargs); 
 ptr=args; 
 
 walker=stackbase; 
 count=0; 
 while (count<nargs) 
 { 
 CAR(ptr)= *walker; 
 ptr=CDR(ptr); 
 ++walker; 
 ++count; 
 } 
 UNSTACK_TMP(fn); 
 
 res=EUCALL_2(compute_and_apply_method,fn, args); 
 { if (1) { BCnil=nil; BCtrue=lisptrue; } }; 
 (sp)=(arg_1-1);; 
 pc=
 ((this_vector=((int)(*(sp)))>>(18+2)), 
 (*(sp))=((LispObject) (((int)((*(sp))))&((1<<(18+2)) - 1))), 
 (bytevectors[this_vector])+((((int)(*(sp)))>>2)) 
 ); 
 ((sp) -= (1)); 
 ((*(sp))=res); 
 break;  
 } 
 
 call_method: 
  
 
 { 
 LispObject mf; 
 
 mf=method_function(CAR(meths)); 
 switch(typeof(mf)) 
 { 
 case TYPE_B_FUNCTION: 
  
 (*((arg_1)-(2))=meths); 
 { 
  
  
 pc=(this_vector=intval(bytefunction_codenum(mf)), 
 (bytevectors[intval(bytefunction_codenum(mf))]) 
 +intval(bytefunction_offset(mf))); 
  
 (*(++sp)=bytefunction_env(mf)); 
 }; 
 break; 
 
 default: 
 { 
 LispObject res; 
 res = call_method(arg_1,nargs,meths); 
 { if (1) { BCnil=nil; BCtrue=lisptrue; } }; 
 (sp)=(arg_1-1);; 
 pc=
 ((this_vector=((int)(*(sp)))>>(18+2)), 
 (*(sp))=((LispObject) (((int)((*(sp))))&((1<<(18+2)) - 1))), 
 (bytevectors[this_vector])+((((int)(*(sp)))>>2)) 
 ); 
 ((sp) -= (1)); 
 ((*(sp))=res); 
 break; 
 } 
 } 
 }; 
 } 
 break; 
 
 case TYPE_B_FUNCTION: 
 case TYPE_B_MACRO: 
 { 
 int real_args=intval(bytefunction_nargs(fn)); 
 if (nargs>=0 && real_args<0) 
 { 
 int j=nargs+1; 
 int k=-real_args; 
 *(++sp)=BCnil; 
  
 while (k!=j) 
 { 
 LispObject tmp; 
 sp--; 
 tmp=Fn_cons(sp); 
 *sp=tmp; j--; 
 } 
 { if (1) { BCnil=nil; BCtrue=lisptrue; } }; 
 } 
 { 
  
  
 pc=(this_vector=intval(bytefunction_codenum(fn)), 
 (bytevectors[intval(bytefunction_codenum(fn))]) 
 +intval(bytefunction_offset(fn))); 
  
 (*(++sp)=bytefunction_env(fn)); 
 }; 
 } 
 break; 
 default: 
 { 
 LispObject res; 
 arg_start=sp-abs_args; 
 res=module_apply_args(arg_start+1,nargs,fn); 
 { if (1) { BCnil=nil; BCtrue=lisptrue; } }; 
 ((sp) -= (abs_args)); 
 pc=
 ((this_vector=((int)(*(sp)))>>(18+2)), 
 (*(sp))=((LispObject) (((int)((*(sp))))&((1<<(18+2)) - 1))), 
 (bytevectors[this_vector])+((((int)(*(sp)))>>2)) 
 ); 
 ((sp) -= (1)); 
 ((*(sp))=res); 
 } 
 break; 
 } 
 } break;
	  
 case BC_APPLY_BVF: 
 { 
 LispObject fn; 
 int nargs; 
 
 nargs = *(pc++);; 
  
 fn=(*(sp--)); 
 { 
  
  
 pc=(this_vector=intval(bytefunction_codenum(fn)), 
 (bytevectors[intval(bytefunction_codenum(fn))]) 
 +intval(bytefunction_offset(fn))); 
  
 (*(++sp)=bytefunction_env(fn)); 
 }; 
 } break;
	  
 case BC_APPLY_METHODS: 
 { 
 LispObject ml; 
 int args; 
 LispObject *base; 
 
 
 args = *(pc++);; 
 base=sp-args; 
 
 ml=(*(sp--)); 
 
 
 { 
 LispObject mf; 
 
 mf=method_function(CAR(ml)); 
 switch(typeof(mf)) 
 { 
 case TYPE_B_FUNCTION: 
  
 (*((base)-(2))=ml); 
 { 
  
  
 pc=(this_vector=intval(bytefunction_codenum(mf)), 
 (bytevectors[intval(bytefunction_codenum(mf))]) 
 +intval(bytefunction_offset(mf))); 
  
 (*(++sp)=bytefunction_env(mf)); 
 }; 
 break; 
 
 default: 
 { 
 LispObject res; 
 res = call_method(base,args,ml); 
 { if (1) { BCnil=nil; BCtrue=lisptrue; } }; 
 (sp)=(base-1);; 
 pc=
 ((this_vector=((int)(*(sp)))>>(18+2)), 
 (*(sp))=((LispObject) (((int)((*(sp))))&((1<<(18+2)) - 1))), 
 (bytevectors[this_vector])+((((int)(*(sp)))>>2)) 
 ); 
 ((sp) -= (1)); 
 ((*(sp))=res); 
 break; 
 } 
 } 
 }; 
 } break;

	  
 case BC_PUSH_LABEL: 
 {  
 bytecode *new_pc; 
 LispObject xx; 
 int i; 
 bytecode *opc=pc; 
  
 i= (int)(*(pc++)); 
 i=(i<<8)+((int)(*(pc++))); 
 i=(i<<8)+((int)(*(pc++))); 
 i= *(pc++) ? -i: i; 
 ;; 
 new_pc=
 ((opc)+((i)-1)); 
 ; 
 xx=
 ((LispObject) 
 ((this_vector<<(18+2)) 
 | (((new_pc)-(bytevectors[this_vector])) << 2) 
 | 3)); 
 (*(++sp)=xx); 
 } break;
	  
	  
	  
 case BC_RETURN:  
 { 
 LispObject tmp=(*(sp--)); 
  
 pc=
 ((this_vector=((int)(*(sp)))>>(18+2)), 
 (*(sp))=((LispObject) (((int)((*(sp))))&((1<<(18+2)) - 1))), 
 (bytevectors[this_vector])+((((int)(*(sp)))>>2)) 
 ); 
 ((sp) -= (1)); 
 ((*(sp))=tmp); 
 } break;
	  
	  
 case BC_EXIT: 
 { 
 ; 
 return ((*(sp--))); 
 } break;

	  	
	  
 case BC_CONS: 
 { 
 LispObject tmp; 
  
 tmp=Fn_cons(sp-1); 
 ((sp) -= (1)); 
 ((*(sp))=tmp); 
 { if (1) { BCnil=nil; BCtrue=lisptrue; } }; 
 } break;
	  
 case BC_ALLOC_CLOSURE: 
 {  
 LispObject env; 
 LispObject rpc; 
 LispObject tmp,tmp2; 
 bytecode *start; 
 int vector; 
 int nargs; 
  
 nargs=(int)((char) *(pc++));; 
 
 tmp=allocate_instance(sp+1,ByteFunction); 
 lval_typeof(tmp)=TYPE_B_FUNCTION; 
 bytefunction_env(tmp)=(*(sp--)); 
 
  
 rpc=(*(sp--)); 
 start=
 ((vector=((int)rpc)>>(18+2)), 
 rpc=((LispObject) (((int)(rpc))&((1<<(18+2)) - 1))), 
 (bytevectors[vector])+((((int)rpc)>>2)) 
 ); 
 (*(++sp)=tmp); 
 tmp2=allocate_integer(sp+1,vector); 
 tmp=(*(sp)); 
 bytefunction_codenum(tmp)=tmp2; 
 tmp=allocate_integer(sp+1,nargs); 
 bytefunction_nargs((*(sp)))=tmp; 
 tmp=allocate_integer(sp+1,start-(bytevectors[vector])); 
 bytefunction_offset((*(sp)))=tmp; 
 { if (1) { BCnil=nil; BCtrue=lisptrue; } }; 
 } break;

	  
	  
 case BC_NULLP: 
 { 
 if ((*(sp))==BCnil)
 ((*(sp))=BCtrue); 
 else 
 ((*(sp))=BCnil); 
 } break;
	  
 case BC_EQP: 
 { 
 LispObject tmp; 
  
 tmp=(*(sp--)); 
  
 if ((*(sp))==tmp) 
 ((*(sp))=BCtrue); 
 else 
 ((*(sp))=BCnil); 
 } break;
	  
	  
 case BC_CONTEXT: 
 { 
 LispObject tmp; 
 tmp=allocate_integer(sp+1,this_vector); 
 (*(++sp)=tmp); 
 } 
 break; 
	  
	  
 default: 
 fprintf(stderr,"No such instruction: %d\n",*(pc-1));;
	}
    }
  
  return nil; 
}




EUFUN_3(Fn_add_codevector,bytes,len, posn)
{
  LispObject new_closure;
  LispObject ptr;
  int i,lim=intval(len);
  bytecode *space;

  space=(bytecode *)allocate_space(stacktop,lim);
  ptr=bytes;

  for (i=0; i<lim ; i++)
    {
      if (!is_fixnum(CAR(ptr)))
	CallError(stacktop,"add codevector: bad byte",CAR(ptr),NONCONTINUABLE);
      
      if (intval(CAR(ptr))>255)
	CallError(stacktop,"add codevector: bad byte number",CAR(ptr),NONCONTINUABLE);

      space[i]=(bytecode)intval(CAR(ptr));
      ptr=CDR(ptr);
    }

  new_closure=allocate_instance(stacktop,ByteFunction);
  lval_typeof(new_closure)=TYPE_B_FUNCTION;

  bytefunction_offset(new_closure)=allocate_integer(stacktop,0);
  bytefunction_nargs(new_closure)=allocate_integer(stacktop,0);
  bytefunction_env(new_closure)=nil;
  bytefunction_codenum(new_closure)=posn;
  bytevectors[intval(posn)]=space;
  return new_closure;
}
EUFUN_CLOSE


EUFUN_1(Fn_load_bytecodes,name)
{
  char buf[1024];
  FILE *file;
  bytecode *code;
  int nslots,nbytes,i;
  LispObject slotvector,*slots;
  
  sprintf(buf,"%s.ebc",stringof(name));
  file=fopen(buf,"r");

  if (file==NULL)
    CallError(stacktop,"Could not open file\n",name,NONCONTINUABLE);

  fgets(buf,1024,file);
  
  if (strcmp(buf,"ASCIIBYTES\n",buf)==0)
    {
      fgets(buf,1024,file);
      nslots=atoi(buf);
      fgets(buf,1024,file);
      nbytes=atoi(buf);

      code=(bytecode *) allocate_space(stacktop,nbytes);      
      bytevectors[static_count]=code;
      slotvector=allocate_static_vector(stacktop,sizeof(LispObject)*nslots);
      static_vectors[static_count]=slotvector;
      slots=&(vref(slotvector,0));
      fprintf(stderr,"code: %x[%d] slots: %x[%d]\n",code,nbytes,slots,nslots);
      statics[static_count]=slots;
      
      for (i=0 ; i<nbytes ; i++)
	{	
	  if (fgets(buf,1024,file)==NULL)
	    perror("fgets");

	  code[i]=(bytecode) (atoi(buf));
	}
      fclose(file);
    }
  else
    {	
      fprintf(stderr,"%s\n",buf);
      CallError(stacktop,"Unknown format: %s\n",nil,NONCONTINUABLE);
    }
  
  
  

  sprintf(buf,"%s.est",stringof(name));
  file=fopen(buf,"r");
  if (file==NULL)
    CallError(stacktop,"load-bytecodes: no file",nil,NONCONTINUABLE);
  else
    {
      extern LispObject Fn_Lex_Yacc_reader(LispObject*,FILE *);
      LispObject new;

      new=Fn_Lex_Yacc_reader(stacktop,file);
      nslots=intval(new);
      for (i=0; i<nslots ; i++)
	{
	  new=Fn_Lex_Yacc_reader(stacktop,file);
	  statics[static_count][i]=new;
	}
    }
  
  {
    LispObject apply_nary_bytefunction(LispObject *, int, LispObject);
    LispObject new_closure;
    new_closure=allocate_instance(stacktop,ByteFunction);
    lval_typeof(new_closure)=TYPE_B_FUNCTION;

    bytefunction_offset(new_closure)=allocate_integer(stacktop,0);
    bytefunction_nargs(new_closure)=allocate_integer(stacktop,0);
    bytefunction_env(new_closure)=nil;
    bytefunction_codenum(new_closure)=allocate_integer(stacktop,static_count);
    static_count++;
    
    return(apply_nary_bytefunction(stacktop,0,new_closure));
  }
}
EUFUN_CLOSE


EUFUN_2(Fn_set_module_statics,module,n)
{
  int i;
  
  i=intval(n);
  module->C_MODULE.values=static_vectors[i];

  return nil;
}
EUFUN_CLOSE

LispObject apply_nary_bytefunction(LispObject *stackbase, int nargs, LispObject fn)
{
  bytecode *start;
  int this_vector; 
  LispObject rfn;
  int i;
  
  if (is_cons(fn))
    rfn=method_function(CAR(fn));
  else 
    rfn=fn;
  
  
  for (i=nargs-1; i>=0 ; i--)
    *(stackbase+i+2)=*(stackbase+i);

  	
  this_vector=0;
  start=exit_bytes;
  *(stackbase+1)=
 ((LispObject) 
 ((this_vector<<(18+2)) 
 | (((start)-(bytevectors[this_vector])) << 2) 
 | 3));

  
  start=(this_vector=intval(bytefunction_codenum(rfn)), 
 (bytevectors[intval(bytefunction_codenum(rfn))]) 
 +intval(bytefunction_offset(rfn)));  
  
  *stackbase=fn;
  *(stackbase+nargs+2)=bytefunction_env(rfn);

  return(interpret_bytes(stackbase+nargs+3,start,this_vector));
}

EUFUN_0(Fn_print_counts)
{
  { 
 int i,j; 
 for (i=0, j=0; i<256; i++) 
 { 
 if (exec_counts[i]!=0) 
 { 
 fprintf(stderr,"%3d: %7d ",i,exec_counts[i]); 
 j++; 
 if ( (j%6) == 0) 
 fputc('\n',stderr); 
 } 
 } 
 if (j%6!=0) fputc('\n',stderr); 
 };

  return nil;
}
EUFUN_CLOSE

void add_boot_module(LispObject mod)
{
  boot_modules[boot_module_count]=mod;
  
  static_vectors[static_count]=mod->C_MODULE.values;
  statics[static_count]=&(vref(mod->C_MODULE.values,0));
  boot_module_count++;
  static_count=boot_module_count;
}

EUFUN_0(Fn_boot_module_list)
{
  LispObject lst,end;
  int i;
  
  lst=EUCALL_2(Fn_cons,nil,nil);
  end=lst; 
  for (i=1; i<boot_module_count; i++)
    { 
      LispObject tmp;

      tmp=EUCALL_2(Fn_cons,boot_modules[i],nil);
      CDR(end)=tmp;
      end=tmp;
    }
  return(lst);
}
EUFUN_CLOSE


MODULE Module_bci;
LispObject Module_bci_values[7];

void initialise_bci(LispObject *stacktop)
{
  int i;
  
  fprintf(stderr,"Bytecodes compiled on: %s\n", "Wed Apr 29 17:54:52 BST 1992");
  
  
  Cb_fn_return=nil;
  add_root(&Cb_fn_return);
  ByteFunction_Class = (LispObject) allocate_class(stacktop,Standard_Class);  
  add_root(&ByteFunction_Class);
  make_class(stacktop,ByteFunction_Class,
	     "bytefunction-class",
	     Standard_Class,
	     Funcallable_Object_Class,
	     0);

  ByteFunction = (LispObject) allocate_class(stacktop,ByteFunction_Class);
  add_root(&ByteFunction);

  make_class(stacktop,ByteFunction,
	     "bytefunction",
	     ByteFunction_Class,
	     Function, N_SLOTS_IN_BYTEFUNCTION);


  open_module(stacktop,
	      &Module_bci,Module_bci_values,"bci",7);
  
  (void) make_module_entry(stacktop,"bytefunction-class",ByteFunction_Class);
  (void) make_module_entry(stacktop,"bytefunction",ByteFunction);
  (void) make_module_function(stacktop,"add-code-vector",Fn_add_codevector,3);
  (void) make_module_function(stacktop,"load-bytecodes",Fn_load_bytecodes,1);
  (void) make_module_function(stacktop,"set-module-statics",Fn_set_module_statics,2);
  (void) make_module_function(stacktop,"boot-module-list",Fn_boot_module_list,0);
  (void) make_module_function(stacktop,"byte-counts",Fn_print_counts,0);
  close_module();

  bytevectors[0]=exit_bytes;
}
