
extern void process_import_spec(LispObject*,LispObject,LispObject);


extern LispObject symbol_ref(LispObject*,LispObject,LispObject,LispObject);

EUDECL(module_eval);
EUDECL(process_top_level_form);
EUDECL(old_module_eval);
EUDECL(module_mv_apply_1);

extern LispObject module_set(LispObject*);
extern LispObject module_set_new(LispObject*,LispObject,LispObject,LispObject);
extern LispObject module_set_new_constant(LispObject*,
					  LispObject,LispObject,LispObject);

extern LispObject put_module(LispObject*,LispObject,LispObject);
extern LispObject get_module(LispObject*,LispObject);
extern int module_loaded_p(LispObject*,LispObject);
extern int module_binding_exists_p(LispObject*,LispObject,LispObject);

extern LispObject register_module_import(LispObject*);
extern LispObject process_exports(LispObject*);

extern LispObject global_module_table;
extern SYSTEM_GLOBAL(LispObject,current_interactive_module);


/******* Really just for calls.c (macroexpansion) and modops *****/
#define BINDING_HOME(x) (CAR(CDR(x)))
#define BINDING_MUTABLE(x) (CAR(CDR(CDR(x))))
#define BINDING_VALUE(x) (CAR(x))

/* All except into+mutable must be safe */
#define MAKE_BINDING(into,mod,value,mutable) \
  into=EUCALL_2(Fn_cons,mutable,nil);		 \
  into=EUCALL_2(Fn_cons,mod,into);		 \
  into=EUCALL_2(Fn_cons,value,into);		 

#define GET_BINDING(mod, sym)	EUCALL_2(Fn_tref,mod->MODULE.bindings,sym)
#define ADD_BINDING(mod, sym, value, mutable) \
{			        	\
  LispObject xx;			\
  STACK_TMP(sym);			\
  MAKE_BINDING(xx,(LispObject)mod,value,mutable);		\
  UNSTACK_TMP(sym);			\
  EUCALL_3(tref_updator,		\
           BINDING_HOME(xx)->MODULE.bindings,sym,xx);	\
}

#define IMPORT_BINDING(mod,name,bind)		\
  EUCALL_3(tref_updator,mod->MODULE.bindings,name,bind);
