/* ******************************************************************** */
/* system.h          Copyright (C) Codemist and University of Bath 1989 */
/*                                                                      */
/* Environment specific code   		                                */
/* ******************************************************************** */

/*

 * System specific types...
 *
 * (see '.c' for details)

 */

#ifndef SYSTEM_T_H

#define SYSTEM_T_H

/*

 * Types and declarations...

 */

/* ******************************************************************** */
/*                             System V                                 */
/* ******************************************************************** */

#ifdef MACHINE_SYSTEMV

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <sys/shm.h>

extern char *shmat(int,char *,int);

typedef int SystemSemaphore;

#define SYSTEM_THREAD_SPECIFIC_DECLARATION(type,name) type name
#define SYSTEM_THREAD_SPECIFIC_VALUE(name)            (name)

#define SYSTEM_GLOBAL(type,name)            volatile type* name
#define SYSTEM_INITIALISE_GLOBAL(type,name,value) \
          (name=(volatile type*)(system_static_malloc(sizeof(type))),*name=value)
#define SYSTEM_GLOBAL_VALUE(name)           (*(name))
#define SYSTEM_GLOBAL_ARRAY1(type,name,n) volatile type* name
#define SYSTEM_INITIALISE_GLOBAL_ARRAY1(type,name,num,val) \
          { \
	    int siga1; \
	    name=(volatile type*)(system_static_malloc(sizeof(type)*num)); \
	    for (siga1=0;siga1<num;++siga1) { \
	      *(name+siga1)=val; \
	    } \
	  }
#define SYSTEM_GLOBAL_ARRAY1_VALUE(name,index) (*(name+index))
#define ADD_SYSTEM_GLOBAL_ROOT(name) add_root(name)

#endif

/* ******************************************************************** */
/*                             Any Machine                              */
/* ******************************************************************** */

#ifdef MACHINE_ANY

typedef int SystemSemaphore;

#define SYSTEM_THREAD_SPECIFIC_DECLARATION(type,name) type name
#define SYSTEM_THREAD_SPECIFIC_VALUE(name) (name)

#define SYSTEM_GLOBAL(type,name) type name
#define SYSTEM_GLOBAL_VALUE(name) (name)
#define SYSTEM_INITIALISE_GLOBAL(type,name,value) name=value
#define SYSTEM_GLOBAL_ARRAY1(type,name,dim) type name[dim]
#define SYSTEM_INITIALISE_GLOBAL_ARRAY1(type,name,num,val) \
          { \
	    int siga1; \
	    for (siga1=0;siga1<num;++siga1) { \
	      *(name+siga1)=val; \
	    } \
	  }
#define SYSTEM_GLOBAL_ARRAY1_VALUE(name,index) (name[index])
#define ADD_SYSTEM_GLOBAL_ROOT(name) add_root(&name)
#endif

/* ******************************************************************** */
/*                               BSD                                    */
/* ******************************************************************** */

#ifdef MACHINE_BSD

typedef int SystemSemaphore;

#define SYSTEM_THREAD_SPECIFIC_DECLARATION(type,name) type name
#define SYSTEM_THREAD_SPECIFIC_VALUE(name)            (name)

#define SYSTEM_GLOBAL(type,name)            type name
#define SYSTEM_INITIALISE_GLOBAL(type,name,value) (name=value)
#define SYSTEM_GLOBAL_VALUE(name)           (name)
#define SYSTEM_GLOBAL_ARRAY1(type,name,n) type name[n]
#define SYSTEM_INITIALISE_GLOBAL_ARRAY1(type,name,num,val) \
          { \
	    int siga1; \
	    for (siga1=0;siga1<num;++siga1) { \
	      *(name+siga1)=val; \
	    } \
	  }
#define SYSTEM_GLOBAL_ARRAY1_VALUE(name,index) (name[index])
#define ADD_SYSTEM_GLOBAL_ROOT(name) add_root(&name)
#endif

#endif SYSTEM_T_H

