;; yep. Philosophers in CSP

(defmodule csp-phil 
  ((rename ((binary-plus +)
	    (binary-times *)
	    (binary-difference -)
	    (binary-gt >)
	    (binary-lt <))
	   (except (+ * - > <)standard0))
   list-fns
   loopsII
   driver
   csp) ()

;;  int num-phils = 5
;;  
;;  CHAN l-chans[num-phils]
;;  CHAN r-chans[num-phils]
;;
;;  PROC phil (l-chan r-chan i)
;;    int x
;;    WHILE TRUE
;;      DO go-in(i)
;;      "req" ! l-chan
;;      "req" ! r-chan
;;      ALT 
;;        x ? l-chan -> x ? rchan
;;	x ? r-chan -> x ? l-chan
;;      DO eat(i)
;;        "free" ! l-chan
;;	"free" ! r-chan
;;      DO leave(i)
;;    END
;;
;;  PROC fork (l-chan r-chan)
;;   int x
;;   WHILE TRUE
;;     ALT
;;       x ? l-chan SEQ ok ! l-chan
;;		      x ? l-chan
;;       x ? r-chan SEQ ok ! r-chan
;;                      x ? r-chan
;;  END                      
;;     	
;;  FOR i = 1 num-phils-1
;;    PAR 
;;      phil(l-chans[i],r-chans[i])
;;      fork(l-chans[i],r-chans[i])
;;    END
;;  END       


  (plot-string X-stream 155 495 "Dining Philosophers in CSP")

  (read-pixmap X-stream "phil.xbm") ;; Philosopher
  (read-pixmap X-stream "thinks.xbm") ;; Idea
  (read-pixmap X-stream "sticks.xbm") ;; Chops
  (read-pixmap X-stream "ticket.xbm") 
  (read-pixmap X-stream "bulb.xbm") 

  (deflocal *think-level* 360)
  (deflocal *eat-level* 140)
  (deflocal *margin* 50)
  (deflocal *space* 80)

  (defun philosophize (i lchan rchan doorchan)
    (let ((x nil))
      (SEQ (enter i doorchan)
	   ;;(format t "Phil: ~a gets in\n" i)	   
	   (SEQ (OUT rchan 'req)
		(OUT lchan 'req))
	   (eat i)
	   (SEQ (OUT rchan 'free)
		(OUT lchan 'free))
	   (leave i doorchan)))
    (philosophize i lchan rchan doorchan))

  (defun enter (i doorchan)
    ;;(format t "Phil: ~a gets to the door\n" i)
    (OUT doorchan 'enter)
    (unplot X-stream 1 (+ *margin* (* i *space*)) (- *think-level* 40))
    (plot X-stream 4 (+ *margin* (* i *space*)) (- *think-level* 40))
    (let ((x (IN doorchan)))
      (unplot X-stream 4 (+ *margin* (* i *space*)) (- *think-level* 40))
      (plot X-stream 3 (+ *margin* (* i *space*)) (+ *eat-level* 40))
      (move X-stream i (+ *margin* (* i *space*)) *eat-level*)))

  (defun init-phil (i)
    	(manage X-stream 0)
	(move X-stream i (+ *margin* (* i *space*))
	      *think-level*)
	(plot X-stream 1 (+ *margin* (* i *space*)) 
	      (- *think-level* 40)))

  (defun leave (i doorchan)
    ;;(format t "Phil: ~a Leaves\n" i)    
    (unplot X-stream 2 (+ *margin* (* i *space*))
	    (- *eat-level* 40))
    (OUT doorchan 'leave)
    (unplot X-stream 3 (+ *margin* (* i *space*)) (+ *eat-level* 40))
    (move X-stream i (+ *margin* (* i *space*)) *think-level*)
    (plot X-stream 1 (+ *margin* (* i *space*)) (- *think-level* 40)))


  (defun eat (i)
    ;;(format t "Phil: ~a Eats\n" i)    
    (plot X-stream 2 (+ *margin* (* i *space*)) (- *eat-level* 40)))

  (defun doorman (chans n-phil)
    (doorman-aux nil chans 0 n-phil))

  (defun doorman-aux (ready-chans live-chans i n-phil)
    (IN-FROM (chan req) live-chans 
       (cond ((eq req 'enter)
	      (cond ((= i (- n-phil 1))
		     (format t "**Problems..\n")
		     (doorman-aux (cons chan ready-chans)
				  (deleteq chan live-chans)
				  i n-phil))
		    ;; no problem...
		    (t (OUT chan 'ok)
		       (doorman-aux ready-chans live-chans (+ i 1) n-phil))))
	     ((eq req 'leave)
	      (cond (ready-chans
		     (OUT (car ready-chans) 'ok)
		     (doorman-aux (cdr ready-chans) 
				  (cons (car ready-chans)
					live-chans)
				  i n-phil))
		    (t
		     (doorman-aux ready-chans live-chans
				  (- i 1) n-phil)))))))
		
  ;; forks...
  (defun fork-task (lchan rchan)
    (let ((dummy nil))
      (ALT ((IN lchan dummy)
	    (IN lchan dummy))
	   ((IN rchan dummy)
	    (IN rchan dummy))))
    (fork-task lchan rchan))
	 
  (defun doit (n)
    (let ((left-channels (mapvect make-Chan-Pair (make-vector n)))
	  (right-channels (mapvect make-Chan-Pair (make-vector n)))
	  (doorman-chans (mapcar make-Chan-Pair (consn n))))
      (PAR (FOR (i 0) (< i n) (++ i)
		(SEQ (format t "Phil ~a starting~%" i)
		     (init-phil i)
		     (philosophize i
				   (connect-chan-pair (vector-ref left-channels i))
				   (connect-chan-pair (vector-ref right-channels i))
				   (connect-chan-pair (nth i doorman-chans)))))
	   (FOR (i 0) (< i n) (++ i)
		(SEQ (format t "Fork: ~a starting~%" i)
		     (fork-task (connect-chan-pair (vector-ref left-channels i))
				(connect-chan-pair (vector-ref right-channels
							       (remainder (+ i 1) n))))))
	   (SEQ (format t "Doorman starting\n")
		(doorman (mapcar connect-chan-pair doorman-chans) n)))))
  
)      


