(defmodule short-path
  (standard0
   loopsII
   list-fns
   csp) ()

  ;; note that this program will fail on graphs with 
  ;; cycles
  
  ;; From Naff benchmarks ltd.

  (defun time (f) (let ((x (cpu-time)))
		    (f)
		    (- (cpu-time)
		       x)))

  (defun m1 () (main *weird-arcs* 6))

  ;; one-shot speedups:
  ;; n-procs   time on invoking processor
  ;;  1        410            1.0
  ;;  2        229            1.79
  ;;  3        166            2.47
  ;;  4        217 ????       1.89

  ;; DEF maxval=3000, termin=99 :
  ;;
  ;;PROC originmode(VALUE m,CHAN out[]) =
  ;;-- outputs path lengths to internal nodes and the terminator tokens
  ;;  SEQ
  ;;    SEQ i=[0 to m]
  ;;      out[i]!1
  ;;    SEQ i_[0 FOR m]
  ;;      out[i]!termin   :
  ;;
  ;;PROC internalnode(VALUE n,m,CHAN in[],out[]) =
  ;;-- stores minimum input path length on any input, and broadcasts
  ;;-- any received value less than the current minimum.  Sends
  ;;-- terminator after receipt of terminator from all inputs
  ;;  VAR minval, endcount  :
  ;;  SEQ
  ;;    minval := maxval		-- initially infinity
  ;;    endcount := 0
  ;;    WHILE TRUE
  ;;      VAR val :
  ;;      ALT i=[0 FOR n]
  ;;        in[i]?val		-- accept any input
  ;;          IF
  ;;            val = termin
  ;;              IF
  ;;                endcount = n-1	-- this is the last
  ;;                  SEQ i=[0 FOR n]
  ;;                    out[i]!termin -- broadcast terminator
  ;;                TRUE
  ;;                  endcount := endcount+1
  ;;            val<minval
  ;;              PAR
  ;;                minval := val
  ;;                SEQ i=[0 FOR m]
  ;;                  out[i]!(val+1)	-- braodcast new minimum
  ;;            TRUE
  ;;              SKIP    :
  ;;
  ;;PROC destinationnode(VALUE n, CHAN in[], numberout) =
  ;;-- stores the minimum value input and outputs minimum when all terminators
  ;;  VAR mindist  :
  ;;  SEQ
  ;;    mindist := maxval		-- initially infinity
  ;;    WHILE TRUE
  ;;      VAR val  :
  ;;      ALT i=[0 FOR n]
  ;;        in[i]?val		-- accept any input
  ;;          IF
  ;;            val = termin
  ;;              IF
  ;;                endcount=n-1	-- last terminator
  ;;                  SEQ
  ;;                    numberout!mindist
  ;;                    STOP
  ;;                TRUE
  ;;                  endcount := endcount+1
  ;;            val < mindist
  ;;              mindist := val
  ;;            TRUE
  ;;              SKIP   :
  ;;                    
  ;;PROC arc(CHAN in,out) =
  ;;  WHILE TRUE
  ;;    VAR val  : 
  ;;    SEQ
  ;;      in?val
  ;;      out!val   :
  ;;
  ;;-- Main program
  ;;CHAN aout[2], bin[1], bout[2], cin[1], cout[2], din[2], dout[1],
  ;;     eout[1], fin[2], screenout  :
  ;;PAR
  ;;  originnode(2,aout)
  ;;  internalnode(1,2,bin,bout)
  ;;  internalnode(1,2,cin,cout)
  ;;  internalnode(2,1,din,dout)
  ;;  internalnode(2,1,ein,eout)
  ;;  destinationnode(2,fin,screenout)
  ;;  arc(aout[0],cin[0])		-- set up arcs
  ;;  arc(aout[1],bin[0])
  ;;  arc(bout[0],din[0])
  ;;  arc(bout[1],ein[0])
  ;;  arc(cout[0],din[1])
  ;;  arc(cout[1],ein[1])
  ;;  arc(dout[0],fin[0])
  ;;  arc(eout[0],fin[1])
  ;;
  ;;-- plus code to print answer

  (defun delq (a lst)
    (delete a lst eq))

  (deflocal *terminator* -1)
  (deflocal *max-val* 9999)

  (defun start-node (out-chans)
    (mapcar (lambda (x) 
	      (OUT x 0))
	    out-chans)
    (format t "Start Node: Terminators~%\n")
    (mapcar (lambda (x) (OUT x *terminator*))
	    out-chans)
    0)

  (defun internal-node (inputs outputs min-val)
    (cond ((null inputs)
	   (format t "I-Node terminating~%")
	   (mapcar (lambda (x) (OUT x *terminator*))
		   outputs)
	   min-val)
	  (t 
	   (IN-FROM (input val) inputs
		    (cond ((= val *terminator*)
			   (internal-node (delq input inputs) outputs min-val))
			  ((< val min-val)
			   (mapc (lambda (x) (OUT x val))
				 outputs)
			   (internal-node inputs outputs val))
			  (t (internal-node inputs outputs min-val)))))))

  (defun dest-node (inputs output min-val)
    (cond ((null inputs)
	   (OUT output min-val)
	   min-val)
	  (t (IN-FROM (input val) inputs
		      (cond ((= val *terminator*)
			     (dest-node (delq input inputs) output min-val))
			    ((< val min-val)
			     (dest-node inputs output val))
			    (t (dest-node inputs output min-val)))))))

  (defun arc (in out length)
    (let ((val (IN in)))
      (cond ((= val *terminator*) 
	     (OUT out *terminator*)
	     length)
	    (t (OUT out (+ val length))
	       (arc in out length)))))
			
  (defun result-printer (input)
    (let ((x (IN input)))
      (format t  "**Result is: ~a~%" x)
      x))


  (deflocal n-nodes 6)
  (deflocal *simple-arcs* '((0 1 1) (0 2 1)
			    (1 3 1) (1 4 1)
			    (2 3 1) (2 4 1)
			    (3 5 1) (4 5 1)))
		   
  (deflocal *weird-arcs* '((0 1 1) (0 2 2) (0 5 10)
			   (1 3 2) (1 4 4)
			   (2 3 2) (2 4 1) 
			   (3 5 2) (4 5 4)))

  ;; make things readable...
  (defun node-in-chan (arc)
    (cadr arc))
  (defun node-out-chan (arc)
    (caddr arc))
  (defun in-node (arc)
    (caar arc))
  (defun out-node (arc)
    (cadar arc))
  (defun arc-length (arc)
    (caddar arc))
    
  (defun main (arcs n-nodes)
    (let ((arc-chans (mapcar (lambda (arc)
			       (list  arc (make-Channel) (make-Channel)))
			     arcs))
	  (result-chan (make-Channel)))
      (PAR (FOR (arc-list arc-chans) arc-list
		(setq arc-list (cdr arc-list))
		(format t "Starting arc: ~a\n" (car arc-list))
		(arc (connect-channel-input (node-out-chan (car arc-list)))
		     (connect-channel-output (node-in-chan (car arc-list)))
		     (arc-length (car arc-list))))
	   (start-node
	    (mapcar (lambda (x) 
		      (connect-channel-output (node-out-chan x)))
		    (collect (lambda (arc-data)
			       (cond ((= (in-node arc-data) 0)
				      arc-data)
				     (t nil)))
			     arc-chans)))
	   (FOR (i 1) (< i (- n-nodes 1)) (++ i)
		(internal-node
		 (mapcar (lambda (x) 
			   (connect-channel-input (node-in-chan x)))
			 (collect (lambda (arc-data)
				    (cond ((= (out-node arc-data) i)
					   arc-data)
					  (t nil)))
				  arc-chans))
		 (mapcar (lambda (x) 
			   (connect-channel-output (node-out-chan x)))
			 (collect (lambda (arc-data)
				    (cond ((= (in-node arc-data) i)
					   arc-data)
					  (t nil)))
				  arc-chans))
		 *max-val*))
	   (dest-node 
	    (mapcar (lambda (arc-data)
		      (connect-channel-input (node-in-chan arc-data)))
		    (collect (lambda (arc-data)
			       (cond ((= (out-node arc-data)
					 (- n-nodes 1))
				      arc-data)
				     (t nil)))
			     arc-chans))
	    (connect-channel-output result-chan)
	    *max-val*)
	   (result-printer (connect-channel-input result-chan)))))
  
  )
