(defmodule fut-groeb
   (standard0
    list-fns
    
    polly
    fut2
    pvm)
  
  ()
  ;;
  ;; Uses the distributed futures module to 
  ;; calculate the groebner basis of some given polynomials.
  ;;
  ;; The structure of the progam is an example of master-slave 
  ;; parallelism using futures. The futures are created by the 
  ;; coordinator function, and then evaluated in order of completion 
  ;; in the second part of the function using future-select.
  ;; the reduce-pair-by set is the worker function.
  
  ;;
  ;;; Groebner reduction routines.
  ;;
  ;

  ;
  ;; Reduce p wrt the set s of polynomials.
  ;; Returns the reduced polynomial or the unreduced original.
  ;

  (defun reduce (p s)
    (let/cc done
      (if (null p) p
	(let ((reduced p))
	  (mapc 
	   (lambda (q) 
	     (let ((red (reduce-by-poly p q)))
	       (cond ((null red) (done nil))
		     ((not (eq red p)) (setq reduced red)))))
	   s)
	  (if (eq p reduced) p (reduce reduced s))))))

  ;
  ;; Reduce p wrt q if possible.
  ;; Returns the reduced polynomial or the unreduced original.
  ;

  (defun reduce-by-poly (p q)
    (let* ((lpp (leading-power-product-with-coef p))
	   (lpq (leading-power-product-with-coef q))
	   (qp (power-product-very-simply-divisible-p lpp lpq)))
      (if (null qp) p
	(let* ((lcmval (lcm (car qp) (cdr qp)))
	       (quo (power-product-without-coef
		      (simple-power-product-quotient lpp lpq)))
	       (reduced (sub-pol
			  (multi-pol (quotient lcmval (car qp)) p)
			  (multi-pol 
			    (multi-pol quo q)
			    (quotient lcmval (cdr qp))))))
	  reduced))))

  ;
  ;;
  ;;; Pair generation utilities.
  ;;
  ;

  ;
  ;; Create the original pairs of a set.
  ;; Returns a list of pairs.
  ;

  (defun construct-pairs (s)
    (if (or (null s) (null (cdr s))) ()
      (nconc 
        (construct-pairs-with (car s) (cdr s))
	(construct-pairs (cdr s)))))

  ;
  ;; Create pairs of and object with a given set.
  ;; Returns a list of pairs.
  ;

  (defun construct-pairs-with (p s)
    (if (null s) ()
      (cons (cons p (car s)) (construct-pairs-with p (cdr s)))))



  ;; Pair reduction linda process function.
  ;
  ;; future function. Should avouid passing the set around, but what the hell

  (defun reduce-pair-by-set (set p1 p2)
    (format t "Work: ~a ~a~%" p1 p2)
    (let ((s (s-pol p1 p2)))
      (reduce s set)))
	
  (define-future-fun 'reduce-pair-by-set reduce-pair-by-set )
  ;
  ;; Linda result coordinator.
  ;

  (defun coordinator (set)
    (format t "COORDINATOR: entered.~%")
    (labels

	((cycle (pairs)
	   (if (null pairs) ()
	       (let ((new-pairs ())
		     ;; Out...
		     (reductions (mapcar
				   (lambda (pair)
				     (format t "COORDINATOR: {P}~%")
				     (dist-future reduce-pair-by-set set (car pair) (cdr pair)))
				   pairs)))
		 (format t "COORDINATOR: Outed all.~%")
		 ;; In
		 (format t "COORDINATOR: Sucking pairs.~%")
		 (fold  ;; use fold to iterate (hacky, but ok)
		   (lambda (task leftover)
		     (format t "COORDINATOR: Sucking tuple.~%")
		     (let* ((new (dist-future-select leftover))
			    (reduced (car new)))
		       (format t "COORDINATOR: Got reduced: ~a~%" new)
		       (unless (null reduced)
			 (setq new-pairs 
			       (nconc (construct-pairs-with reduced set) 
				      new-pairs))
			 (setq set (cons reduced set)))
		       (cdr new)))
		   reductions
		   reductions)
		 (cycle new-pairs)))))

      (cycle (construct-pairs set))
      set))
      
  ;
  ;; Initiate a linda system.
  ;
  ;; schedulers may be repeated... 
  (defun groebner (set)
    (coordinator set))
  

(deflocal hosts '(black boysen choke))

(defun startup ()
  ;; random big number
  ((setter future-threshold) 1024)
  ;; load-path , start-module, server rest
  (initialise-network '("DVSM") 'fut-groeb lazy-server (car hosts) (cdr hosts)))
  

;  (setq r1 '(((x . 2) . 1) ((y . 2) . 1)))
;  (setq r2 '(((x . 1) . (((y . 1) . 1))) . -3))

  (setq a1 '(((x . 1) . 3) ((y . 3) . -1)))
  (setq a2 '(((y . 4) . 1) . -9))

  (setq s1 '(((x . 1) . 1)))
  (setq s2 '(((x . 1) . 1) ((y . 1) . 1)))

  (setq y1 '(((y . 1) . -1)))
  (setq y2 '(((y . 2) . -1)))
  (setq s '((((y . 1) . -1)) (((x . 1) . 1)) (((x . 1) . 1) ((y . 1) . 1))))

  ;; end module
)
