;; Correct implementation of futures [I hope]

(defmodule fut2
    (standard0 
      list-fns 

      pvm-support 
      handler
      low-fut
      genread
      reader
      threads
      )
  ()
  ;; Two parts to this... The server and the clients
  ;; The server lives in fut-serv.em
  ;; I'll replace the single server with a clever internal one sometime
  ;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;

  ;; client side
  ;;

  ;; client globals

  (deflocal *the-server* ())

  (defun the-server () *the-server*)

  ((setter setter) the-server 
   (lambda (x) (setq *the-server* x)))

  (defstruct task-server ()
    ((location initarg location reader task-server-location)
     (completed-tasks initform '((-2 ())) 
		      accessor server-completed-tasks)
     (spare initform () accessor server-spare-req)
     (count initform 0 accessor server-count)
     (local-count initarg local initform 0 
		  accessor server-local-count)
     ;; proxies
     (proxy-waits initform () 
		  accessor server-proxy-waits)
     (proxy-completes initform ()
		      accessor server-proxy-completes))
	     constructor (make-task-server location))

  ;; banned from working...
  (defstruct lazy-server task-server
	     ()
	     predicate lazy-server-p)
  
  ;; implies we can only have one server
  (defmethod initialize-instance ((proto task-server) lst)
    (let ((new-server (call-next-method)))
      (register-handler *result-msg*
			(lambda (msg)
			  (add-result new-server (cdr (car msg)))))
      (register-handler *proxy-msg*
			(lambda (msg)
			  (handle-proxy-result new-server
					       (car msg))))
      new-server))

  (export task-server lazy-server)

  (defun remote-client-startup (server-id)
    (format t "Client at: ~a~%" server-id)
    (let ((s (make-task-server (pvm-make-id-from-pair server-id))))
      (initialise-reader s)
      ((setter the-server) s)
      (client-loop s (grab-result -1))))

  (export remote-client-startup)
  
  ;; Futures to the outside world

  (defstruct fut-task ()
    ((value initform 'ugh 
	    accessor remote-task-value))
    )

  (defstruct dist-task fut-task
    ((id initarg id reader remote-task-id))
     constructor (make-unevaluated-task id)
    )

  ;; task created on some other machine
  ;; a *proxy-msg* will be sent when the task completes

  (defstruct proxy-task fut-task
    ((id initarg id reader proxy-task-id)
     (host initarg host reader proxy-task-host))
    constructor (make-proxy-waiter host id)
    )
  (defconstant proxy-task-value remote-task-value)

  (defmethod generic-prin ((x fut-task) stream)
    (if (eq (remote-task-value x) 'ugh)
	(call-next-method)
      (format stream "#<~a=~a>" (class-name (class-of x)) (remote-task-value x))))
	
	     
  (defconstant find-fut-fn (mk-finder))
  (defconstant find-fun (mk-finder))

  (defun define-future-fun (name fn)
    ((setter find-fut-fn) fn name)
    ((setter find-fun) name fn))
  
  (export dist-future make-dist-future dist-future-value
	  dist-future-select define-future-fun) 
  
  (defun dist-future (fun . args)
    (if (make-task-p fun)
	(let ((t-id (make-task-id fun)))
	  (register-task (the-server) t-id fun args -1)
	  (make-unevaluated-task t-id))
      (start-task fun args)))

  (defun make-dist-future (where fn args)
    (let ((t-id (make-task-id fn)))
      (register-task (the-server) 
		     t-id fn
		     args where)
      (make-unevaluated-task t-id)))
    
  ;; list of futures --> (completed . rest)
  (defun dist-future-select (l)
    (let ((res (internal-future-select (the-server) l)))
      (cons (dist-future-value (car res))
	    (cdr res))))

  (defun make-task-p (task)
    (handle-results (the-server))
    (< (server-count (the-server)) (future-threshold)))
  
  ;; smileys all round
  (defconstant future-threshold
    (let* ((x 10)
	   (fun (lambda () x)))
      ((setter setter) fun
       (lambda (y) (setq x y)))
      fun))
  
  (export future-threshold)

  (defconstant task-count (mk-counter 0))

  ;; task id is (where . number)

  (defun make-task-id (task)
    (cons (pvm-whoami) (task-count)))

  (defgeneric dist-future-value (object)
    methods ((((x object)) x)
	     (((thing dist-task))
	      (if (eq (remote-task-value thing) 'ugh)
		  (let ((res (dist-future-value
			       (internal-task-result (the-server) thing
						     (remote-task-id thing)))))
		    ((setter  remote-task-value) thing res)
		    res)
		  (remote-task-value thing)))
	     (((thing proxy-task))
	      (if (eq (proxy-task-value thing) 'ugh)
		  (let ((res (dist-future-value
			       (internal-proxy-result (the-server) thing
						      (proxy-task-id thing)
						      (proxy-task-host thing)))))
		    ((setter proxy-task-value) thing res)
		    res)
		  (proxy-task-value thing)))))

  (defun internal-task-result (server thing id)
    (format t "Waiting for: ~a~%" id)
    (if (eq (remote-task-value thing) 'ugh)
	(let ((v1 ((grab-result (cdr id)) server)))
	  (if (eq (car v1) 'ok)
	      (cadr v1)
	      (let ((res (wait-4-task server id)))
		(format t "done: id: ~a ~a~%" id res)
		res)))
	(remote-task-value thing)))

  (defun internal-proxy-result (server thing id host)
    (if (eq (proxy-task-value thing) 'ugh)
	(let ((v1 ((grab-proxy host id) server)))
	  (if (eq (car v1) 'ok)
	      (cadr v1)
	      (let ((res (wait-4-proxy server host id)))
		res)))
	(proxy-task-value thing)))
  
  (defun wait-4-task (server task-id)
    (let ((val 'ugh)
	  (thread (current-thread)))
      ((setter server-local-count) server (- (server-local-count server) 1))
      (add-callback (assoc (cdr task-id) 
			   (server-completed-tasks server)
			   =)
		    (list 'callback
			  (lambda (result)
			    (setq val result)
			    ((setter server-local-count) server
			     (+ (server-local-count server) 1))
			    (thread-start thread))))
      (thread-suspend)
      (if (eq val 'ugh) 
	  (thread-reschedule) ())
      val))

  (defun wait-4-proxy (server host id)
    (let ((val 'ugh)
	  (thread (current-thread)))
      ((setter server-local-count) server
       (- (server-local-count server) 1))     
      (add-callback (assoc id (cdr (assoc host
					  (server-proxy-waits server)
					  equal)) =)
		    (list 'callback (lambda (result)
				      (setq val result)
				      ((setter server-local-count) server
				       (+ (server-local-count server) 1))
				      (thread-start thread))))
      (thread-suspend)
      val))

	
  (defgeneric block-fn (x)
    methods ((((x dist-task))
	      (grab-result (cdr (remote-task-id x))))
	     (((x proxy-task))
	      (grab-proxy (proxy-task-host x) (proxy-task-id x)))))

  (defun internal-future-select (server l)
    (client-loop server
		 (mk-wait (mapcar (lambda (x) 
				    (list (block-fn x) 
					  (deleteq x l)))
				  l))))
  
  (defun mk-wait (fns)
    (lambda (server)
      (check-list server fns)))

  (defun check-list  (server lst)
    ;; seems better to do this here --- results come in batches...
    (let ((xx (check-list-aux server lst)))
      (if (eq (car xx) 'ok)
	  xx
	(progn (handle-results server)
	       (check-list-aux server lst)))))

  (defun check-list-aux (server lst)
    (if (null lst) '(())
	(let ((xx ((caar lst) server)))
	  (if (eq (car xx) 'ok)
	      (list 'ok (cons (cadr xx) (cadr (car lst))))
	      (check-list-aux server (cdr lst))))))

  ;; mucking about with completed-tasks...

  (defun register-task (server id fn args where)
    ((setter server-completed-tasks) server
     (cons (list (cdr id) 'undone)
	   (server-completed-tasks server)))
    ((setter server-count) server (+ (server-count server) 1))
    (pvm-send (task-server-location server)
	      *server-msg*
	      (list 'add-task (list id fn args where))
	      (add-writers (default-reader) server
			   (task-server-location server))
	      ))
			   

  ;; result is (id value)
  (defun add-result (server result)
    (let ((id (car result))
	  (res (cadr result)))
      ((setter server-count) server (- (server-count server) 1))
      (add-result-aux server (server-completed-tasks server) id res)
      nil))

  (defun add-result-aux (server lst id res)
    (let ((obj (assoc id lst =)))
      (if (or (null lst) (null obj)) (error "oh heck" clock-tick) ())
      (mapc (do-callback res server)
	    (cddr obj))
      ;; note that it has been done
      ((setter car) (cdr obj) res)
      ;; forget about the callbacks
      ((setter cdr) (cdr obj) nil)
      nil))

  (defun client-loop (server waitfor)
    (let ((xx (waitfor server)))
      ;;(format t "loop: ~a~%" server)
      (handle-results server)
      (cond ((eq (car xx) 'ok)
	     ;; what we've all been waiting for...
	     (format t "Client: Done: ~a~%" (cadr xx))
	     (cadr xx))
	    ((pvm-probe *result-msg*)
	     (let ((msg (pvm-recv *result-msg* () (default-reader))))
	       (add-result server (cdr msg))
	       (client-loop server waitfor)))
	    ((> (server-local-count server) 0)
	     (thread-reschedule)
	     (client-loop server waitfor))
	    (t  (if (or (lazy-server-p server)
			(server-spare-req server))
		    ()
		    (progn (pvm-send (task-server-location server)
				     *server-msg*
				     (list 'task-request (pvm-whoami)))
			   ((setter server-spare-req) server t)))
		(let/cc cont 
			(with-handler (handle-errors cont)
			  (wait-4-message server
					  (list	(cons *client-msg*
						      (lambda (msg)
							((setter server-spare-req) server nil)
							(get-task server (cdr (car msg)))))
						;;(cons *stats-msg*
						;;(lambda (msg)
						;;(format t "Running: ~a~%"
						;;(- (system-time)
						;;(task-start-time server)))
						;;(rshow server)))
						))))
		(client-loop server waitfor)))))

  (defun wait-4-message (server handlers)
    (let* ((time (system-time))
	   (res (handle-msgs handlers nil)))
      res))

  (defun start-task (fn args)
    (apply fn args))

  (defun get-task (server taskbit)
    (let ((task (car taskbit)))
      (format t "Got Task: ~a~%" task)
      ((setter server-local-count) server (+ (server-local-count server) 1))
      (thread-start
       (make-thread 
	(lambda ()
	  (format t "Task starting~%")
	  (let ((result (apply (cadr task) (caddr task)))
		(where (caar task)))
	    (format t "Client: done ~a ~a~%" 
		    task result)
	    ((setter server-local-count) server
	     (- (server-local-count server) 1))
	    (pvm-send where 
		      *result-msg*
		      (list 'set-result (cdar task) result)
		      (add-writers (default-reader) server where))))))))
			       
  
  (defun handle-errors (cont)
    (lambda (c1 c2)
      ;;(rshow c1)
      (format t "Error Message: ~a~%Error Value: ~a~%" 
	      (condition-message c1)
	      (condition-error-value c1))
      (flush (standard-output-stream))
      (backtrace)
      (flush (standard-output-stream))
      ;;(cont)))
      ))

  (defun handle-results (server)
    (if (probe-handle-msgs () (list *client-msg*))
	(handle-results server)
	()))
  ;; getting results from the server
  
  (defun grab-result (id)
    (lambda (server)
      (grab-res-aux (server-completed-tasks server) id)))
    
  (defun grab-res-aux (lst id)
    (cond ((null lst) '(()))
	  ((= id (caar lst))
	   (if (eq (cadar lst) 'undone)
	       '(())
	       (let ((res (cadar lst)))
		 ((setter car) lst
		  (cadr lst))
		 ((setter cdr) lst
		  (cddr lst))
		 (list 'ok res))))
	  (t (grab-res-aux (cdr lst) id))))
  
  ;;
  ;; Sending and recieving remote-task-objects
  ;;

  ;; adding to a uncompleted-future's list of things to do...
  
  (defun register-proxy-callback (server proxy-host proxy-id tohost id)
    (add-callback (assoc proxy-id 
			 (cdr (assoc proxy-host (server-proxy-waits server) 
				     equal))
			 =)
		  (cons tohost id))
    nil)

  (defun register-task-callback (server task-id tohost id)
    (add-callback (assoc (cdr task-id)
			 (server-completed-tasks server) =)
		  (cons tohost id))
    nil)

  (defun add-callback (lst obj)
    (nconc lst (list obj))
    )
    
  ;; and using the info 
  (defun do-callback (res server)
    (lambda (obj)
      (if (eq (car obj) 'callback)
	  ;; note that this is a hack to save memory.
	  ;; We should really do this in add-result --- or when the
	  ;; proc. completes 
	  (progn ((cadr obj) res)
		 ((setter cdr) obj nil))
	(progn (pvm-send (car obj) *proxy-msg*
			 (list (pvm-whoami)
			       (cdr obj) res)
			 (add-writers (default-reader) server 
				      (car obj)))
	       ))))

  
  ;; when we get a *proxy-msg*
  
  (defun handle-proxy-result (server msg)
    (let ((host (car msg))
	  (id (cadr msg))
	  (res (caddr msg)))
      (add-result-aux server
		      (cdr (assoc host (server-proxy-waits server) equal))
		      id res)
      ;;(format t "Proxy result: ~a~%"  (server-proxy-waits server))
      nil))

  
  ;; when we rcv a new proxy
  (defun make-new-proxy-waiter (server host id)
    (let ((xx (assoc host (server-proxy-waits server) equal)))
      ;; install into wait-list
      (if xx 
	  ((setter cdr) xx (cons (list id 'undone) (cdr xx)))
	  ((setter server-proxy-waits) server 
	   (cons (list host (list id 'undone) '(-2 ()))
		 (server-proxy-waits server))))
      ;;(format t "Mk-New: Waits: ~a~%" (server-proxy-waits server))
      nil))

  ;; encoding and decoding the things
  (defconstant make-proxy-id (mk-counter 0))

  (defun mk-proxy-write (server host)
    (lambda (proxy value reader)
      (let ((xx (peek-proxy-value server proxy)))
	;;(format t "Write: ~a~%" xx)
	(if (eq (car xx) 'ok)
	    (write-next (cdr xx) value reader)
	    (let ((next-id (make-proxy-id)))
	      (register-proxy-callback server
				       (proxy-task-host proxy)
				       (proxy-task-id proxy)
				       host next-id)
	      (write-next 'ugh value reader)
	      (write-next (pvm-whoami) value reader)
	      (write-next next-id value reader))))))

  (defun mk-task-write (server host)
    (lambda (task value reader)
      ;; NB should check more thoroughly...
      (let ((xx (peek-task-value server task)))
	;;(format t "Write: ~a~%" xx)
	(if (eq (car xx) 'ok)
	    (write-next (cdr xx) value reader)
	    (let ((next-id (make-proxy-id)))
	      (register-task-callback server (remote-task-id task) host next-id)
	      (write-next 'ugh value reader)
	      (write-next (pvm-whoami) value reader)
	      (write-next next-id value reader))))))
  
  (defun peek-task-value (server task)
    (if (eq (remote-task-value task) 'ugh)
	(let ((rec (assoc (cdr (remote-task-id task))
			  (server-completed-tasks server) =)))
	  (if (eq (cadr rec) 'undone)
	      '(())
	      (cons 'ok (cadr rec))))
	(cons 'ok (remote-task-value task))))
  
  (defun peek-proxy-value (server task)
    (if (eq (proxy-task-value task) 'ugh)
	(let* ((val (assoc (proxy-task-id task)
			   (cdr (assoc (proxy-task-host task)
				       (server-proxy-waits server)
				       equal))
			   =)))
	  (if (eq (cadr val) 'undone)
	      '(())
	      (cons 'ok (cadr val))))
	(cons 'ok (proxy-task-value task))))
			   
  ;; should read both proxys and tasks

  (defun mk-proxy-read (server)
    (lambda (value reader)
      (let ((xx (read-next value reader)))
	(if (eq xx 'ugh)
	    (let* ((host (read-next value reader))
		   (id (read-next value reader)))
	      (make-new-proxy-waiter server host id)
	      (make-proxy-waiter host id))
	    xx))))
	
  (defun add-writers (writer server host)
    (add-writer writer dist-task *task-object* 
		(mk-task-write server host))
    (add-writer writer proxy-task *task-object*
		(mk-proxy-write server host))
    writer)
  ;; getting proxy values for the main loop 
  ;;
  (defun grab-proxy (host id)
    (lambda (server)
      (let ((lst (assoc host (server-proxy-waits server) equal)))
	;;(format t "Grab-proxy: (~a,~a) ~a"
	;;host id  (server-proxy-waits server))
	(grab-res-aux (cdr lst) id))))

  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;; start up
  ;;
  (defun initialise-network (load-path initmod server-class 
				server-name client-names)
    (if (the-server) () (start-local-pvm))
    (let ((server-id (start-server server-name load-path)))
      ((setter the-server) 
       (make-instance server-class 'local 1 'location server-id))
      (initialise-reader (the-server))
      (thread-start (make-thread client-loop) (the-server) (lambda a '(())))
      (let ((clients (mapcar (lambda (name) 
			       (start-client server-id name load-path initmod))
			     client-names)))
	clients)))

  (defun initialise-reader (server)
    (add-reader (default-reader) 
		*task-object* 
		(mk-proxy-read server))
    (add-reader (default-reader)
		*function-object*
		function-reader)
    (add-writer (default-reader)
		function
		*function-object*
		function-writer))

  (defun as-string (x) (format nil "~a" x))

  (defun start-server (name path)
    (let ((obj (pvm-initiate-by-hostname (as-string name) "pvm-feel")))
      (pvm-set-load-path obj path)
      (pvm-start obj 'fut-serv 'remote-start-server ())
      obj))


  (defun start-client (server-id name path initmod)
    (let ((obj (pvm-initiate-by-hostname (as-string name) "pvm-feel")))
      (pvm-set-load-path obj path)
      (pvm-start obj initmod 'remote-client-startup (list server-id))
      obj))

  (export initialise-network)

  (defun do-stats ()
    (pvm-send (make-pvm-id "pvm-feel") *stats-msg* ()))

  (export do-stats)

  ;; icky hacks

  (defmethod equal ((x fut-task) y)
    (equal (dist-future-value x) (dist-future-value y)))

  (defmethod equal (x (y fut-task))
    (equal y x))


  )
      
