(defmodule page
  (standard0
   list-fns
   scan-args

   low-dvsm)
  ()

  ;; normal pages
  (defstruct page abs-page
     ((content initarg content 
	       accessor page-content)
      (id initarg id 
	  reader page-id))
     constructor (make-page size id)
     constructor (copy-page content id))

  (defmethod initialize-instance ((pg page) lst)
    (let ((new-obj (call-next-method)))
      (let ((size (scan-args 'size lst ())))
	(if size
	    ((setter page-content) new-obj
	     (make-vector size nil-value))
	    nil)
	new-obj)))

  (defmethod page-ref ((pg page) loc offset)
    (vector-ref (page-content pg) (+ loc offset)))

  (defmethod (setter page-ref) ((pg page) loc offset value)
    ((setter vector-ref) (page-content pg) (+ loc offset) value))
  
  (defun page-size (page)
    (vector-length (page-content page)))

  (export page-size make-page copy-page page page-id page-content)
 )
