;; Eulisp Module
;; Author: pete broadbery
;; File: waiters.em
;; Date: 20/may/1991
;;
;; Project:
;; Description: 
;;  allows wait + restart of thredas
;;

(defmodule waiters 
  (standard0
   list-fns
   semaphores)
  ()
  
  
  (defstruct waiter ()
    ((table initform (make-table eq)
	    reader waiter-table)
     (recycle initform () accessor waiter-recycle)
     (lock initform (make-semaphore)
	   reader waiter-lock))
    constructor make-waiter)

  (defun get-next-id (waiter)
    (gensym))

  (defun add-waiter (waiter id function)
    (open-semaphore (waiter-lock waiter))
    (cond ((table-ref (waiter-table waiter) id)
	   (function (table-ref (waiter-table waiter) id)))
	  (t ((setter table-ref) (waiter-table waiter) id
	      function)))
    (close-semaphore (waiter-lock waiter)))

  (defun restart-waiter (waiter id result)
    (open-semaphore (waiter-lock waiter))
    (cond ((table-ref (waiter-table waiter) id)
	   ((table-ref (waiter-table waiter) id)
	    result)
	   ((setter table-ref) (waiter-table waiter) id nil))
	  (t ((setter table-ref) (waiter-table waiter) id
	      result)))
    (close-semaphore (waiter-lock waiter)))
    
  (defun wait-on-id (waiter id)
    (let ((result nil)
	  (thread (current-thread)))
      (add-waiter waiter id
		  (lambda (ob)
		    (setq result ob)
		    (thread-start thread)))
      (thread-suspend)
      result))

  (export make-waiter add-waiter restart-waiter wait-on-id get-next-id)

  ;; end module
  )
