;; Eulisp Module
;; Author: pete broadbery
;; File: queens.em
;; Date: 21/sep/1991
;;
;; Project:
;; Description: 
;;  Fast hack at n-queens problem using PVM.
;;

(defmodule queens 
  (standard0
   list-fns

   dist-task
   )
  ()

  (deflocal N 8)

  (defun legalp (board n c) 
    ;;% Test Conditions
    (cond ((zerop n) (legalp board 1 c))
	  ((null board) t)
	  ((equal (car board) c) nil)
	  ((equal n 
		  (abs (- c (car board))))
	   nil) 
	  (t (legalp (cdr board) 
		     (+ n 1)
		     c))))

  (defun allboards (newpiece board)
    (cond ((> newpiece N) nil)
	  ((legalp board 0 newpiece) 
	   (cons (cons newpiece board)
		 (allboards (+ newpiece 1)
			    board)))
	  (t (allboards (+ newpiece 1)
			board))))

  ;; depth-first.
  (defun nqueens (list listlen) 
    (prin (car list))
    (print listlen)
    (cond ((null list) nil)
	  ((equal (list-length (car list)) N) 
	   (cons (car list) listlen))
	  (t (nqueens (append (allboards 1 
					 (car list))
			      (cdr list))
		      (max (list-length list)
			   listlen) ))))

  (defun nqueensa (list listlen)
    (cond ((null list) nil)
	  ((equal (list-length (car list)) N) 
	   (cons (cons (car list)
		       listlen)
		 (nqueensa (cdr list)
			   listlen)))
	  (t (nqueensa (append (allboards 1 (car list))
			       (cdr list))
		       (max (list-length list) 
			    listlen)))))

  ;; new stuff

  (defun nqueens-all (obj)
    (if (= (list-length obj) N)
	(list obj)
      (let ((new (mapcar (lambda (x)
			   (do-task 'nqueens-all x))
			 (allboards 1 obj))))
	(fold append (mapcar task-result new) ()))))

  (define-task 'nqueens-all nqueens-all)

  (deflocal hosts '(strachey fili crump mordell bombur nori))

  (defun startup ()
    (initialise-network () 'queens (car hosts) (cdr hosts)))
  
  
  ;; end module
  )
  
18.5 mins (1 Processor)
9 mins (5 Processors)
1:25:50
1:34:50

1:43:10
1:50:25
7.25 mins (9 Processors)
2:21:40
2:29:05 (7.5 mins 4 Processors)

6.5 with improved task-allocation order.(9 proc)
5 mins ditto (5 proc)

14:49:30
   57
  8 mins (3 processors)

5:00:50 7 mins

nqueensa
5:08:21
5:29 (21 mins)

6 processors [7,low 3, high 6]
5:33 7 mins
