.TH Feel 1L "July, 1992"
.SH NAME
feel \- Eulisp interpreter 
.SH SYNOPSIS
.B feel 
[-heap n] [-stack-space n] [-boot \fIbootimage\fR]

.SH DESCRIPTION
Feel (Free and Eventually EuLisp) is a prototype implementation of the
EuLisp language. 
.LP
EuLisp is a single-valued lisp-like language with the following
features: 
.LP
An integrated Object System (Telos). This is a fully reflective
system, and is much more tightly integrated into the system than
CLOS
.LP
A module system, allowing names and implentation to be hidden across
files.
.LP
Parallel programming primitives. 
.LP
Feel attempts to conform to the EuLisp definition, except where,
for historical reasons it has not caught up with the definition, or
the definition contains bogus, unimplementable, or just plain silly
statements.

.SH Options
.IP \fB-heap\fI n\fR 
Allocate an initial heap size of \fIn\fR megabytes. The default is 4,
and is probably too high. 3 meg will result in faster execution times.
.IP \fB-stack-size\fI n\fR
Allocate \fIn\fR megabytes for stacks. Normally, you will not need
this option
.IP \fB-boot \fIbootimage\fR 
load the bytecodes in \fIbootimage\fR on startup. You will need a boot
image for this. 
.SH Getting started
The system initialially is in the root module, which contains no
useful bindings. You will need to be in the standard module, or
something which imports it to do anything useful

In any module,
(!> module-name) will enter a module, loading it if necessary. It
first looks for the file in the current directory, then down the
environment variable FEEL_LOAD_PATH. All bindings in that module then
become available. To interacively import one module into another, use
(import <mod-name>)

(!>> module-name) is the same as !>, except that it always loads the
module from disk.

(loaded-modules) gives the list of currently loaded modules (including
the internal ones, which are in turn re-exported by standard0).

(load-module module-name) will load the module and print the
resulting module. This is the easiest way of finding out what a module
exports. 

(load-path) gives the current value of the load path (see above).
(set-load-path x) sets the load path.

The !> and !>> forms can be used anywhere, while the others can only
be invoked from the root module. !root will always return to the root
module. 

Error handler:
.br
!exit exits the error handler
.br
!b gives a backtrace
.br
!q gives a quick backtrace

.LP
.SH FILES
.IP /usr/local/lib/feel/Modules 
 Directory containing feel startup code and example modules. 
.IP /usr/local/lib/feel/Modules/user.em
 The simplest possible module
.IP /usr/local/lib/feel/Images    
Boot code for the bytecompiler (currently empty).
.IP ${HOME}/.feelrc
User's initial startup file
.SH "SEE ALSO"
.IP /usr/local/lib/feel/Man/feel.dvi
The Feel manual
.SH AUTHOR
Peter A Broadbery <maspab@gdr.bath.ac.uk>, plus some others who would
prefer to remain anonymous, including Julian Pagdet, Russel Bradford
and John ffitch.

.SH BUGS
Almost certainly. Mail to eubug@maths.bath.ac.uk if you find anything
really nasty.
