;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                           ;;
;;  EuLisp Module                     Copyright (C) University of Bath 1991  ;;
;;                                                                           ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defmodule counter (standard) ()

  (defun make-counter ()
    (let ((count 0))
      (lambda (d)
	(cond
	  ((eq d 'up) (setq count (+ count 1)))
	  ((eq d 'down) (setq count (- count 1)))
	  ((numberp d) (setq count (+ count d)))
	  (t 'strange)))))

  (deflocal counter (make-counter))

)
