;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                           ;;
;;  EuLisp Module                     Copyright (C) University of Bath 1991  ;;
;;                                                                           ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defmodule eldecl

;  ( classes) ()

  (classes)

;  (syntax)

  (defstruct zero-address () ())

  (defstruct one-address ()
    ((rand1 initform nil initarg rand1 accessor rand1)))

  (defstruct two-address one-address
    ((rand2 initform nil initarg rand2 accessor rand2)))

  (defstruct three-address two-address
    ((rand3 initform nil initarg rand3 accessor rand3)))

  (export rand1 rand2 rand3)

  (defstruct return-op zero-address () constructor make-return)

  (defstruct alloc one-address () constructor make-alloc)
  (defstruct alloca one-address () constructor make-alloca)
  (defstruct dealloca one-address () constructor make-dealloca)
  (defstruct jump one-address () constructor make-jump)
  (defstruct label one-address () constructor make-label)

  (defstruct entry two-address () constructor make-entry)
  (defstruct load two-address () constructor make-load)
  (defstruct store two-address () constructor make-store)
  (defstruct link two-address () constructor make-link)
  (defstruct gctrap two-address () constructor make-gctrap)

  (defstruct jumpeq three-address () constructor make-jumpeq)
  (defstruct cons-op three-address () constructor make-cons)

;  (only (rand1
;         rand2
;         rand3
;         make-return
;         make-alloc
;	  make-alloca
;	  make-dealloca
;	  make-jump
;	  make-label
;	  make-entry
;	  make-load
;	  make-store
;	  make-link
;	  make-gctrap
;	  make-jumpeq
;	  make-cons)
;    ( eldecl))

  (export return-op make-return
          alloc make-alloc
	  alloca make-alloca
	  dealloca make-dealloca
	  jump make-jump
	  label make-label
	  entry make-entry
	  load make-load
	  store make-store
	  link make-link
	  gctrap make-gctrap
	  jumpeq make-jumpeq
	  cons-op make-cons)
)
