;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                           ;;
;;  EuLisp Module                     Copyright (C) University of Bath 1991  ;;
;;                                                                           ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defmodule fut

  (classes
   extras
   lists
   list-operators
   streams
   arith
   others
   ccc) ()

  ;; Book-keeping...

  (deflocal future-count-value 0)

  (defun future-count () future-count-value)

  (defun set-future-count (n) (setq future-count-value n))

  (defun increment-future-count () 
    (setq future-count-value (+ future-count-value 1)))

  (defun zero-future-count () (setq future-count-value 0))

  (export future-count set-future-count 
          increment-future-count zero-future-count)

  ;; Future structure...

  (defstruct future-object ()
    ((function accessor future-object-function)
     (thread accessor future-object-thread)
     (value accessor future-object-value)
     (done  initform nil
            accessor future-object-done))
    constructor make-future-object)

  (export future-object future-object-value future-object-function
	  future-object-done make-future-object future-object-thread)

  (defun futurep (obj) (eq (class-of obj) future-object))

  (export futurep)

  ;; Future macro...

  (defmacro future exp
    `(let 
       ((future (make-future-object))
	(task (lambda (future fun)
		((setter future-object-value) future (fun))
		((setter future-object-done) future t)
		t)))
       ((setter future-object-thread) future task)
       ((setter future-object-function) future (lambda () ,@exp))
;;       (thread-start task future (lambda () ,@exp)) 
;;       (print "Made future")
       (increment-future-count)
       future))
       
  (export future)

  (defun futureeval (fut)
    (if (futurep fut)
	(if (future-object-done fut) (futureeval (future-object-value fut))
	  (progn
;;	    (thread-value (future-object-thread fut))
	    ((future-object-thread fut) fut (future-object-function fut))
	    (futureeval fut)))
;;      (print fut)
	fut))
	
  (export futureeval)				  
     
  (defun future-done-p (fut) (future-object-done fut))

  (export future-done-p)

)
