;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                           ;;
;;  EuLisp Module                     Copyright (C) University of Bath 1991  ;;
;;                                                                           ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defmodule net-p-c

  (lists
   list-operators
   extras
   streams
   others
   formatted-io
   sockets
   arith
   vectors
   tables
   ccc
   polly) ()

  (deflocal client-socket nil)

  (defun run-client (data name) 
    (setq client-socket (connect data))
    ;; Identify myself...
    (socket-write client-socket name)
    (format t "\n'~a' starting to serve...\n\n" name)
    (client-dispatch)
    (format t "\nDone.\n"))

  (defun client-dispatch ()
    (let ((op (socket-read client-socket)))
      (cond ((eq op 'stop)
	     (close-socket client-socket)
              (exit))
	    ((eq op 'plus)
	     (run-plus)
	     (client-dispatch))
	    ((eq op 'minus)
	     (run-minus)
	     (client-dispatch))
	    ((eq op 'times)
	     (run-times)
	     (client-dispatch))
	    (t (format t "Unknown operator: ~a\n" op)
	       (client-dispatch)))))

  (defun run-plus ()
    (let ((r1 (socket-read client-socket))
	  (r2 (socket-read client-socket)))
      (format t "+ ~a ~a\n" r1 r2)
      (let ((ans (add-pol r1 r2)))
	(format t "= ~a\n" ans)
	(socket-write client-socket ans)
	ans)))

  (defun run-minus ()
    (let ((r1 (socket-read client-socket))
	  (r2 (socket-read client-socket)))
      (format t "- ~a ~a\n" r1 r2)
      (let ((ans (sub-pol r1 r2)))
	(format t "= ~a\n" ans)
	(socket-write client-socket ans)
	ans)))

  (defun run-times ()
    (let ((r1 (socket-read client-socket))
	  (r2 (socket-read client-socket)))
      (format t "* ~a ~a\n" r1 r2)
      (let ((ans (multi-pol r1 r2)))
	(format t "= ~a\n" ans)
	(socket-write client-socket ans)
	ans)))

)


