/* ******************************************************************** */
/*  error.h          Copyright (C) Codemist and University of Bath 1989 */
/*                                                                      */
/* Error and Signal handling	                                        */
/* ******************************************************************** */

/*
 * Change Log:
 *   Version 1, April 1989
 */


#ifndef ERROR_H
#define ERROR_H

#ifndef SETJMP_H
#define SETJMP_H
#include <setjmp.h>
#endif

typedef struct { Env env; jmp_buf buf; } Restarts;

extern Restarts read_eval_print_loop;

#define is_condition(op) (EUCALL_2(Fn_subclassp,classof(op),Default_Condition)!=nil)

LispObject CallError(LispObject *, char *, LispObject, int);
void signal_message(LispObject *,int,char *,LispObject);
void signal_heap_failure(LispObject *, int);

extern LispObject function_default_handler;
/* condition representation */

#define condition_message(x) (slotref((x),0))
#define condition_error_value(x) (slotref((x),1))


/* The conditions, used as index into table */

#define INTERNAL_ERROR			(0)

#define UNBOUND_LEXICAL_VARIABLE	(1)
#define UNBOUND_DYNAMIC_VARIABLE	(2)
#define INVALID_OPERATOR		(3)
#define NO_UPDATE_FUNCTION		(4)
#define IMMUTABLE_BINDING		(5)
#define NO_BLOCK_FOR_RETURN		(6)
#define NO_CATCH_FOR_THROW		(7)

#define CLOCK_TICK			(8)
#define DEAD_CONTINUATION		(9)
#define DEAD_THREAD			(10)
#define THREAD_OVERFLOW			(11)
#define THREAD_UNDERFLOW		(12)

#define CANNOT_MAKE_ARRAY		(13)
#define CANNOT_MAKE_CHARACTER		(14)
#define CANNOT_MAKE_CHARACTER_SET	(15)
#define CANNOT_MAKE_FLOAT		(16)
#define CANNOT_MAKE_NUMBER		(17)
#define CANNOT_MAKE_PAIR		(18)
#define CANNOT_MAKE_READTABLE		(19)
#define CANNOT_MAKE_STREAM		(20)
#define CANNOT_MAKE_STRING		(21)
#define CANNOT_MAKE_SYMBOL		(22)
#define CANNOT_MAKE_TABLE		(23)
#define CANNOT_MAKE_THREAD		(24)

#define FLOATING_OVERFLOW		(25)
#define FLOATING_UNDERFLOW		(26)
#define INTEGER_OVERFLOW		(27)
#define INTEGER_UNDERFLOW		(28)
#define NOT_A_NUMBER			(29)

#define NON_EXISTENT_FILE_OR_DEVICE	(30)
#define NOT_AN_INPUT_DEVICE		(31)
#define NOT_AN_INPUT_STREAM		(32)
#define NOT_AN_OUTPUT_DEVICE		(33)
#define CANNOT_ACCESS_FILE		(34)
#define CANNOT_APPEND_TO_DEVICE		(35)

#define SLOT_UNBOUND                    (36)
#define SLOT_MISSING                    (37)
#define BAD_SLOT_INDEX                  (38)
#define NO_LAMBDA_LIST                  (39)
#define NON_ALLOCATABLE_OBJECT          (40)
#define NO_APPLICABLE_METHOD            (41)
#define NON_CONGRUENT_LAMBDA_LISTS      (42)

#define CANNOT_MAKE_VECTOR              (43)

#define HEAP_EXHAUSTED                  (44)

#define	UNINITIALIZED_LEXICAL_VARIABLE	(45)
#define	CANNOT_ASSIGN_VARIABLE		(46)
#define	INVALID_OPERANDS		(47)
#define	IMMUTABLE_LOCATION		(48)
#define	CANNOT_MODIFY_EMPTY_LIST	(49)
#define	NAME_CLASH_IN_MODULE		(50)
#define	CANNOT_UNQUOTE_SPLICE		(51)
#define	SEMAPHORE_ALREADY_DOWN		(52)
#define	CANNOT_MAKE_FUNCTION		(53)
#define	CANNOT_MAKE_IO_STREAM		(54)
#define	CANNOT_MAKE_STRUCTURE_CLASS	(55)
#define	CANNOT_OPEN_PATH		(56)
#define	FILE_ALREADY_EXISTS		(57)
#define	INCONSISTENT_OPEN_OPTIONS	(58)
#define	INVALID_STREAM_POSITION		(59)
#define	NOT_AN_OUTPUT_STREAM		(60)
#define	NOT_AN_IO_STREAM		(61)
#define	NOT_A_CHARACTER_STREAM		(62)
#define	NOT_A_BINARY_STREAM		(63)
#define	NOT_A_POSITIONABLE_STREAM	(64)
#define	PATH_DOES_NOT_EXIST		(65)
#define	STREAM_NOT_OPEN			(66)
#define	NON_CONGRUENT_LAMBDA_LIST	(67)
#define	NO_NEXT_METHOD			(68)
#define	METHOD_IN_USE			(69)
#define	INVALID_RETURN_CONTINUATION	(70)
#define	INVALID_THROW_CONTINUATION	(71)
#define	CANNOT_MAKE_TOKENISER		(72)
#define	BAD_METHOD_CLASS		(73)

#define Reader_CallError(sp,msg,val,foo) \
  (ON_collect(), CallError(sp,msg,val,foo))

#endif /* ERROR_H */
/* end of error.h */
