/* Low Level Forth Floating Point Primitives for This Forth */

static void floatcheck(void);  /* Prototype */

static void floatcheck(void)
{
	if ((unsigned)(F - fstack) >= FSTACK_CELLS - 1)
		sorry("(Floating Stack Error)");
}

Immediate(`FLITERAL') fliteral(); Done

void fliteral(void)
{
	if (! state) return ;
	latest = c(NEXT);
	u.Double = ftop, fpop;
	c(u.Short[0]), c(u.Short[1]), c(u.Short[2]), c(u.Short[3]);
}
	Behavior
		u.Short[0] = code[I++], u.Short[1] = code[I++],
		u.Short[2] = code[I++], u.Short[3] = code[I++],
		fpush u.Double;
	Done

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* Floating Point Stack Operations */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

Execution(`FDEPTH') push F - fstack; Done
Execution(`FDROP') fpop; Done
Execution(`FDUP') *++F = ftop; Done
Execution(`FNIP') F--; Done				/* Not Standard */
Execution(`FOVER') fpush F[-1]; Done
Execution(`FSWAP') f = ftop, ftop = *F, *F = f; Done
Execution(`FROT')
		f = F[-1], F[-1] = *F, *F = ftop, ftop = f;
Done

Execution(`FPICK') *++F = ftop, ftop = F[-top], pop; Done /* Not Standard */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* Floating Point Operations */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

Execution(`S>F') fpush (double)top, pop; Done
Execution(`F>S') push (cell)ftop, fpop; Done

Execution(`F.')
	fprintf(usrout, "%G ", ftop);
	fpop;
Done

Execution(`F+') ftop += *F--; Done
Execution(`F-') ftop = *F-- - ftop; Done
Execution(`F*') ftop *= *F--; Done
Execution(`F/') ftop = *F-- / ftop; Done

Execution(`FSQRT') ftop = sqrt(ftop); Done
Execution(`F**') ftop = pow(*F--, ftop); Done

Execution(`FABS') ftop = fabs(ftop); Done
Execution(`FLN')  ftop =log(ftop); Done
Execution(`FEXP') ftop = exp(ftop); Done
Execution(`FSIN') ftop = sin(ftop); Done
Execution(`FCOS') ftop = cos(ftop); Done
Execution(`FTAN') ftop = tan(ftop); Done
Execution(`FACOS') ftop = acos(ftop); Done
Execution(`FASIN') ftop = asin(ftop); Done
Execution(`FATAN') ftop = atan(ftop); Done
Execution(`FATAN2') ftop = atan2(*F--, ftop); Done

Execution(`F<')	push *F-- < ftop LOGICAL; fpop; Done
Execution(`F>') push *F-- > ftop LOGICAL; fpop; Done  /* Not Standard */
Execution(`F0<') push ftop < 0.0 LOGICAL; fpop; Done
Execution(`F0=') push ftop == 0.0 LOGICAL; fpop; Done

Execution(``>FLOAT'')
{
	char *pp;
	
	/* Make NUL-terminated string at &name[finger] from *S,top */
	move((char*)&name[finger], &name[*S], top);
	name[finger+top] = EOS;
	S--;
	f = strtod((char*)&name[finger], &pp);
	if (*pp == EOS)
		fpush f, top = TRUE;
	else {
		while (*pp == SPACE) pp++;
		if (*pp == EOS)
		         fpush f, top = TRUE;
		else
		          top = FALSE;
	}
}
Done

Execution(`F!')
        u.Double = ftop, fpop;
        move(&name[top], &u.Double, sizeof(double)), pop;
Done

Execution(`F@')
        move(&u.Double, &name[top], sizeof(double)), pop;
        fpush u.Double;
Done
