
/*   Copyright (C) 1990 Riet Oolman

This file is part of GLASS.

GLASS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GLASS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GLASS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* file: check.afuncs.p
   author: H. Oolman
   last changed: 13-7-1990
   purpose: access FUNCTIONs for the internal type representation for the
            type checker
   modifications:
		p2c translated, tmc access procs.
*/

#include "handleds.h"
#include "check.ds.h"
#include "check.var.h"

typcrec *BuildSINGLEARROW(valtcarg, valtcres)
typcrec *valtcarg, *valtcres;
{
  typcrec *result;

  result = (typcrec *)malloc(sizeof(typcrec));
  result->kind = kindSINGLEARROW;
  result->SINGLEARROW.tcarg = valtcarg;
  result->SINGLEARROW.tcres = valtcres;
  return result;
}  /* BuildSINGLEARROW*/


typcrec *BuildINT()
{
  typcrec *result;

  result = (typcrec *)malloc(sizeof(typcrec));
  result->kind = kindINT;
  return result;
}  /* BuildINT*/


typcrec *BuildFLOAT()
{
  typcrec *result;

  result = (typcrec *)malloc(sizeof(typcrec));
  result->kind = kindFLOAT;
  return result;
}  /* BuildFLOAT*/


typcrec *BuildBOOL()
{
  typcrec *result;

  result = (typcrec *)malloc(sizeof(typcrec));
  result->kind = kindBOOL;
  return result;
}  /* BuildBOOL*/


typcrec *BuildSTRING()
{
  typcrec *result;

  result = (typcrec *)malloc(sizeof(typcrec));
  result->kind = kindSTRING;
  return result;
}  /* BuildSTRING*/


typcrec *BuildSYSTY(valsysdirs, valsyscomp)
dirgraphrec *valsysdirs;
typcrec *valsyscomp;
{
  typcrec *result;

  result = (typcrec *)malloc(sizeof(typcrec));
  result->kind = kindSYSTY;
  result->SYSTY.sysdirs = valsysdirs;
  result->SYSTY.syscomp = valsyscomp;
  return result;
}  /* BuildSYSTY*/


typcrec *BuildEMPTYT()
{
  typcrec *result;

  result = (typcrec *)malloc(sizeof(typcrec));
  result->kind = kindEMPTYT;
  return result;
}  /* BuildEMPTYT*/


typcrec *BuildLOC(vallocname, valinst)
symbol vallocname;
long valinst;
{
  typcrec *result;

  result = (typcrec *)malloc(sizeof(typcrec));
  result->kind = kindLOC;
  result->LOC.locname = vallocname;
  result->LOC.inst = valinst;
  return result;
}  /* BuildLOC*/


typcrec *BuildBASETY(valbtname, valbnr, valorig)
symbol valbtname;
long valbnr;
orig valorig;
{
  typcrec *result;

  result = (typcrec *)malloc(sizeof(typcrec));
  result->kind = kindBASETY;
  result->BASETY.btname = valbtname;
  result->BASETY.bnr = valbnr;
  result->BASETY.bor = valorig;
  return result;
}  /* BuildBASETY*/


typcrec *BuildCT(valtcfirst, valtcrest)
typcrec *valtcfirst, *valtcrest;
{
  typcrec *result;

  result = (typcrec *)malloc(sizeof(typcrec));
  result->kind = kindCT;
  result->CT.tcfirst = valtcfirst;
  result->CT.tcrest = valtcrest;
  return result;
}  /* BuildCT*/


typcrec *BuildALL(vallocs, valtcall)
nminstrec *vallocs;
typcrec *valtcall;
{
  typcrec *result;

  result = (typcrec *)malloc(sizeof(typcrec));
  result->kind = kindALL;
  result->ALL.locs = vallocs;
  result->ALL.tcall = valtcall;
  return result;
}  /* BuildALL*/


typcrec *BuildAPS()
{
  typcrec *result;

  result = (typcrec *)malloc(sizeof(typcrec));
  result->kind = kindAPS;
  return result;
}  /* BuildAPS*/


typcrec *BuildUNKNOWN(valunknm, valmustendemp, valmustconn)
long valunknm;
boolean valmustendemp, valmustconn;
{
  typcrec *result;

  result = (typcrec *)malloc(sizeof(typcrec));
  result->kind = kindUNKNOWN;
  result->UNKNOWN.unknm = valunknm;
  result->UNKNOWN.mustendemp = valmustendemp;
  result->UNKNOWN.mustconn = valmustconn;
  return result;
}  /* BuildUNKNOWN*/


typcrec *BuildSOME(valtcpart, valsomnr)
typcrec *valtcpart;
long valsomnr;
{
  typcrec *result;

  result = (typcrec *)malloc(sizeof(typcrec));
  result->kind = kindSOME;
  result->SOME.tcpart = valtcpart;
  result->SOME.somnr = valsomnr;
  return result;
}  /* BuildSOME*/


typcrec *BuildINDIR(valtcind)
typcrec *valtcind;
{
  typcrec *result;

  result = (typcrec *)malloc(sizeof(typcrec));
  result->kind = kindINDIR;
  result->INDIR.tcind = valtcind;
  return result;
}  /* BuildINDIR*/


dirgraphrec *BuildCd(valdgfirst, valdgrest)
dirgraphrec *valdgfirst, *valdgrest;
{
  dirgraphrec *result;

  result = (dirgraphrec *)malloc(sizeof(dirgraphrec));
  result->kind = kindCd;
  result->Cd.dgfirst = valdgfirst;
  result->Cd.dgrest = valdgrest;
  return result;
}  /* BuildCd*/


dirgraphrec *BuildOd(valbasedir)
dirrec *valbasedir;
{
  dirgraphrec *result;

  result = (dirgraphrec *)malloc(sizeof(dirgraphrec));
  result->kind = kindOd;
  result->Od.basedir = valbasedir;
  return result;
}  /* BuildOd*/


dirgraphrec *BuildSd(valdgpart, valdglast)
dirgraphrec *valdgpart, *valdglast;
{
  dirgraphrec *result;

  result = (dirgraphrec *)malloc(sizeof(dirgraphrec));
  result->kind = kindSd;
  result->Sd.dgpart = valdgpart;
  result->Sd.dglast = valdglast;
  return result;
}  /* BuildSd*/


dirrec *BuildIN()
{
  dirrec *result;

  result = (dirrec *)malloc(sizeof(dirrec));
  result->kind = kindINTO;
  return result;
}  /* BuildIN*/


dirrec *BuildOUT()
{
  dirrec *result;

  result = (dirrec *)malloc(sizeof(dirrec));
  result->kind = kindOUT;
  return result;
}  /* BuildOUT*/


dirrec *BuildNON()
{
  dirrec *result;

  result = (dirrec *)malloc(sizeof(dirrec));
  result->kind = kindNON;
  return result;
}  /* BuildNON*/


nminstrec *Buildnminstptr(valnm, valinst)
symbol valnm;
long valinst;
{
  nminstrec *result;

  result = (nminstrec *)malloc(sizeof(nminstrec));
  result->next = NULL;
  result->nm = valnm;
  result->inst = valinst;
  return result;
}  /* Buildnminstptr */


Void Appendnminstptr(list, element, result)
nminstrec *list, *element, **result;
{
  nminstrec *hdef;

  if (list == NULL) {
    *result = element;
    return;
  }
  hdef = list;
  while (hdef->next != NULL)
    hdef = hdef->next;
  hdef->next = element;
  *result = list;
}  /* Appendnminstptr */


long newname()
{
  /* delivers an unique name (number) for a yet unknown type */
  long Result;

  Result = namessupply;
  namessupply++;
  return Result;
}  /* newname */




/* End. */
