
/*   Copyright (C) 1990 Riet Oolman

This file is part of GLASS.

GLASS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GLASS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GLASS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

int fscan_bool( f, p )
 FILE *f;
 bool *p;
{ char word[WORDBUFSIZE];
	*p = boolNIL;
	if( fscancons( f, word ) ) return( 1 );
	if( strcmp( word, "True" ) == 0 )
	{ *p = true; }
	else if( strcmp( word, "False" ) == 0 )
	     { *p = false; }
	     else 
	     {(void) sprintf( tmerrmsg, tm_badcons, "bool", word );
	      return( 1 ); }
	return(0);
}

int fscan_symbol(f,s)
FILE *f;
symbol *s;
{ char *st;
  long l;

  *s = symbolNIL;
  if (fscan_string(f,&st))
  {return(1);}
  else
  {
    l = 0; while (st[l] != '\0') {l++;};
     *s = Buildsymbol(st,l);
     return(0);
  }
}

int fscan_symbol_list( f, p )
 FILE *f;
 symbol_list *p;
{
	int n;
	register int c;
	symbol new;
	register short int err = 0;

	*p = symbolNIL;
	n = fscanopenbrac( f );
	if( tmfneedc( f, '[' ) ) return( 1 );
	if( fscanspace( f ) ) return( 1 );
	c = getc( f );
	if( c == EOF ){
		(void) strcpy( tmerrmsg, tm_badeof );
		return( 1 );
	}
	if( c == ']' ) return( 0 );
	ungetc( c, f );
	while( 1 ){
		err = fscan_symbol( f, &new );
		*p = app_symbol_list( *p, new );
		if(err) return( 1 );
		if( fscanspace( f ) ) return( 1 );
		c = getc( f );
		if( c == EOF ){
			(void) strcpy( tmerrmsg, tm_badeof );
			return( 1 );
		}
		if( c != ',' ){
			ungetc( c, f );
			break;
		}
	}
	if( tmfneedc( f, ']' ) ) return( 1 );
	return( fscanclosebrac( f, n ) );
}

int fscan_emp(f,p)
FILE *f;
emp *p;
{ *p = empNIL;
  *p = (emp)malloc(sizeof(typcrec));
  return(0);
}

void print_bool(b)
bool b;
{
  if (b) {printword("True");} else {printword("False");};
}

void print_symbol(s)
symbol s;
{
  s->body[s->length]='\0'; /* just to be sure */
  print_string(s->body);
}

/* Print list of elements of type 'symbol'
 * using print optimization routines.
 */
void print_symbol_list( l )
 symbol_list l;
{
    openlist();
    while( l!=symbolNIL ){
	print_symbol( l );
	l=l->next;
    }
    closelist();
}

symbol Copysymbol(s)
symbol s;
{
  symbol result;

  result = (symbol )Malloc(sizeof(stringcell));
  result->next = NULL;
  result->length = s->length;
  memcpy(result->body, s->body, s->length);
  return result;
}  /* Copysymbol */

symbol Buildsymbol(s, l)
Char *s;
long l;
{
  symbol result;

  if (l>wordlength) 
  {fprintf(stderr, "%s is too long for a symbol", s); return;}
  result = (symbol )Malloc(sizeof(stringcell));
  memcpy(result->body, s,l);
  result->length = l;
  result->next = NULL;
  return result;
}


Void Writesymbol(f, s)
FILE *f;
symbol s;
{ if (s!=NULL)
  { s->body[s->length] = '\0';
    fprintf(f,s->body);
  }
}

boolean Equalsymbol(s1, s2)
symbol s1, s2;
{ s1->body[s1->length] = '\0';
  s2->body[s2->length] = '\0';
  return (cmp_string(s1->body,s2->body)==0);
}  /* Equalsymbol */

/* append list of symbol 'b' after list of symbol 'a' */
static symbol app_symbol_list( a, b )
 symbol_list a;
 symbol b;
{
    register symbol tl;

    if( a == symbolNIL ) return( b );
    tl = a;
    while( tl->next != symbolNIL ) tl = tl->next;
    tl->next = b;
    return( a );
}

