/*   Copyright (C) 1990 Riet Oolman

This file is part of GLASS.

GLASS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GLASS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GLASS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* file: handcom.h
   Riet Oolman
   used commonly for data structure handling of full language
   and communication macro expander - size check */

#include "p2c.h"
#include <tmc.h>

#define wordlength      256

#define specch          '%'

#define specstr         "%ta"


typedef Char wordtype[wordlength+1];

typedef struct stringcell {
  struct stringcell *next;
  long length;
  wordtype body;
} stringcell;

typedef struct stringcell *symbol;

#define symbol_list symbol
#define inum int
#define fnum double
#define bool boolean
#define emp struct typcrec *

#define symbolNIL (symbol)0
#define symbol_listNIL (symbol_list)0
#define inumNIL (inum)0
#define fnumNIL (fnum)0
#define boolNIL (bool)0
#define empNIL (emp)0

extern void print_symbol();
extern void print_symbol_list();
#define print_inum print_int
#define fprint_inum fprint_int
#define print_fnum print_double
#define fprint_fnum fprint_double
extern void print_bool();
#define print_emp(a) /* print empty */

extern int fscan_symbol();
extern int fscan_symbol_list();
#define fscan_inum fscan_int
#define fscan_fnum fscan_double
extern int fscan_bool();
extern int fscan_emp();

extern symbol Copysymbol ();

/* constructs a string from a word (undefined length) and
   an integer, which defines the length of this string */
extern symbol Buildsymbol PP((Char *s, long l));

/* Writes one symbol to the file 'f' */
extern Void Writesymbol PP((FILE *f, symbol s));

/* Compares two strings, and delivers 'true' if the length of both
   strings is the same, and any character, until 'length', is the
   same */
extern boolean Equalsymbol PP((symbol s1, symbol s2));

extern symbol app_symbol_list();
/* append list of symbol 'b' after list of symbol 'a' */
