
/*   Copyright (C) 1990 Riet Oolman

This file is part of GLASS.

GLASS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GLASS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GLASS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* file: mainsk.c
   author: H. Oolman
   last changed: 13-7-'90
   purpose: check if a macro-expanded glass text has fitting connections
            (correct sizes), and replaces : and indexing (given the exact
            sizes)
   modifications:
        p2c translated, tmc access procs
*/

#include "handleds.h"
#include "check.ds.h"
#include "check.var.h"
#include "check.afuncs.h"
#include "errorenv.h"
#include "size.h"

Static def_list glasstext;

main(argc,argv)
int argc;
Char *argv[];
{ takewarning = false;
  if (fscan_def_list(stdin,&glasstext))
  {fprintf(stderr,"error in input of sk: %s\n",tmerrmsg); exit(1);}
  else
  {
    checksize(glasstext);
    if (errordiscovered) { exit(1L); } 
    else 
    { setprint(stdout,0,256);
      print_def_list(glasstext);
      exit(0L);
    }
  }
}
