/*

    This file is a part of the GLAMMAR source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  Eric Voss, ericv@cs.kun.nl 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "ge1.h"
#ifdef LOOP
void loop_line_mode (rroot)
void (*rroot)();
{
   affix *raf = af;
   char * rc =c;
   if (!ll_mode) {(*rroot)(); return; }
   ip = input;
   do {
      *ip++ = getc(inputfile);
      nrofchars += 1;
      if (*(ip-1) == '\n' ) {
         int pcount = parsecount;
         limitip = ip;
         mip = input;
         *(ip-1) = '\0';
         *ip = '\n';
         ip = input;
         (*rroot)();
         if (parsecount == pcount)
            fprintf(stderr, "error on line %d, input = `%s' \n", set_line_num,
                input,q);
         ip = input;
         nrofchars = 0;
         set_line_num+=1;
         if ((set_line_num == 2) && (ll_count != 0)) {
            fprintf(stderr, "root = %x' \n", rroot);
      /*    rroot = uloop;   */
            fprintf(stderr, "root = %x' \n", rroot);
         }
         q -=1; c = rc ; af = raf;
      }
   }  while ( !feof(inputfile) ) ;
       exit(0);
}
#endif

#ifdef ERMSG  
int errline(b,e)
char *b,*e;
{
   if (b> e) {
      return;
   }
   if (e > (b+75) ) {
      b = e -75;
      fprintf (stderr,"@");
   }
   while (b<=e)
      fprintf (stderr,"%c",*b++);
   fprintf (stderr,"\n",*b++);
}

int underline(b,e)
char *b,*e;
{
   if (b> e) {
        fprintf(stderr,"\n^(012)\n");
      return;
   }
   if (e> b+75) 
      b = e -76;
    for (; b <= e; b++) {
       if (b == mip) {
        int o = *mip;
        o &= 255;
        fprintf(stderr,"^(%o)\n",o);
        break;
       }
       else if (*b == '\t')
        fprintf(stderr,"\t");
       else  fprintf(stderr,"-");
    }
          
}
int errmsg()
{
   char *beginmsg,*endmsg;
   int linenumber = 1;

   if (emsg_count >0) 
      return(1);

   if (parsecount != 0) {
      if (output_to_stdout)  {
         fclose(stdout);
      } else {
         putc('\012',output);
         fclose(output);
      }
      return(exit_code);
   }

   /* say file */

   if (*current_file_name != '\0')
      fprintf (stderr,"\n*** file: %s\n", current_file_name);

   if (rmax >0 )
      fprintf(stderr, "\n*** While parsing \"%s\"\n",error_msg);

   if (*mip == '\0') {
      fprintf(stderr, "*** Syntax error after EOF\n");
      return(1);
   }

   /* say line number */
   { 
     char *count;
   if ((mip > limitip )  || (mip < input) ) {
      fprintf(stderr, "*** glammar compiler error in \"errmsg\"\n\
     failed to compute linenumber\n");
      exit(1);
   }
   linenumber = set_ip_start_num;
   for (count = set_ip_start_pos; count < mip;)
      if (*count++ == '\n')
         linenumber += 1;
   if (*count == '\n')
      linenumber += 1;

   fprintf(stderr, "*** Syntax error on line %d:\n", linenumber);
   }
   /* print line before erroneous line,  max 76 chars */

   if (linenumber > 1)  {
      for (beginmsg = mip; *beginmsg-- != '\n';) ;
      endmsg = beginmsg;
      for (; *beginmsg-- != '\n';) ;
      beginmsg +=2;
      errline(beginmsg,endmsg);
      beginmsg = endmsg+2;
   }
   else beginmsg = input;


   /* print errline */
   endmsg = mip;
   while (*endmsg != '\0')
      if (*endmsg++ == '\n') {
         endmsg -=2;
         break;
      }
   errline (beginmsg,endmsg);
   underline (beginmsg,endmsg);

   /* print line after error line*/
  endmsg +=2;
  beginmsg = endmsg;
   if (*endmsg != '\0')  {
      while (*endmsg)
         if (*endmsg++ == '\n') {
            endmsg -=2;
            break;
         }
   }
   errline (beginmsg,endmsg);
   return(1);
}

void             result() {
  if (emsg_count >0) return;
  if (report_stacksize) {
    int             stack_size;
    stack_size = stack_bottum - (int) &stack_size;
    fprintf (stderr, "\nHere is how much storage glammar used:\n");
    fprintf(stderr, "eval count = %d\n", eval_count);
    fprintf(stderr, 
"backtrack stack size = %dk (out of ?), increase with csh command limit()\n", 
           (stack_size >> 10) + 1);
    fprintf(stderr, 
  "char stack size  = %dk (out of %dk), increase with -cn (1 = 512k)\n", 
              (((long) c - (long) cstore) >> 10) + 1,
              ( cssize >> 10) + 1);
    fprintf(stderr, 
  "affix stack size  = %dk (out of %dk), increase with -hn (1 = 6m)\n",  
          (((long) af - (long) affix_heap) >> 10) + 1,
              ((afhsize*12) >> 10) + 1);
  }
  if (output == 0) {
    if (output_to_stdout)
      output = stdout;
    else
      output = fopen(out_file_name, "w");
  }
  printa(output, q->a);
  fflush(output);
}
#endif     

#ifdef PRINTA
void             printa(outdir, afx)
register AFFIX afx;
FILE           *outdir;
{
  register char * cp ;
tailrecel:
  if (afx == nil)
    return;
  cp = afx ->t;
  if (cp == fast_list_acces) {
    fprintf(outdir, "!<LNODE_%d>!", afx->r);
    return;
  }
  if (cp == undefined) {
    fprintf(outdir, "!@!");
    return;
  }
  if (cp != empty) {
    if (*cp ==  '\001' || *cp == '\002') 
      fprintf(outdir, "!<%x>!%s", cp+1,cp+6);
    else fprintf(outdir, "%s", afx->t);
  }
  printa(outdir, afx->l);
/*  printa(outdir, afx->r); */
  afx = afx ->r;
  goto tailrecel;
}

void sprinta(afx)
register AFFIX afx;
{
  register char  *cp, *rc;
tailrecel:
  if (afx == nil)
    return;
  cp = afx -> t;
  if (cp == fast_list_acces) {
    fprintf(stderr, "system error: evaluating list node\n");
    exit(1);
  }
  if (cp == undefined) {
       if (rmax > 0) 
          fprintf(stderr, "==> %d :\n", rmax);
       fprintf(stderr, "Glammar message:\nIn sprinta (\"%s\"): trying to evaluate uninstantiated affix.\n",cp);
      parsecount = 0;
      errmsg();
      exit (1); 
      
  }
  if (cp != empty) {
    eval_count += 1;
    for (rc = c; *cp != '\0'; )
          if (*cp ==  '\001' || *cp == '\002')  {
                 *rc = *cp;
                 *(rc+1) = *(cp+1);
                 *(rc+2) = *(cp+2);
                 *(rc+3) = *(cp+3);
                 *(rc+4) = *(cp+4);
                 *(rc+5) = *(cp+5);
                 cp +=6; rc +=6;
          } else *rc++ = *cp++;

    c = rc;
    if (rc > cstore_top) cstore_overflow(); 
  }
  sprinta((*afx).l);

/*   sprinta((*afx).r);   tail recursion eliminations */
  afx = afx ->r;
  goto tailrecel;
 
}
#endif

