#-d
%^TEX
\documentstyle[glammar]{article}
\topmargin      0 mm
\headheight     0 mm
\headsep        0 mm
\textheight     240 mm
\footskip       7 mm
\footheight     11 mm

\oddsidemargin  0 mm
\evensidemargin 0 mm
\textwidth      159.2 mm
\author{Eric Voss}
\title{glammar to \LaTeX transducer}
\makeindex
\begin{document}
\maketitle

This is a pretty printer for glammar source text.  It is essential a transducer
from glammar source to  --- a modified version of --- the tgrind
macro package written in tex.

\section{glammar}
\def\margin{\hskip 2mm\relax}
%

a glammar source ( STUFF>):
    "?", !\n 	!,->;
a glammar source ( header+layout+options+rules+trailor+"\n">):
    options (options>),
    plain glammar text (header>, trailor>),
    layout (layout>),
    rules (rules>).

rules ("\Proc{"+line+"}"+rule +rules>):
    line num (line>),
    rule (rule>),
    rules (rules>),->;
rules (empty>):    .

rule ("\K{"+metaname+"}" +meta rule>):
    affix identifier (metaname>),
    rest meta rule (meta rule>), ->;
rule (hyperrule>):
    hyperrule (hyperrule>).

hyperrule (lhs+alternative+more hyperrules>):
    bold lhs (lhs>),
    alternative (alternative>),
    more hyperrules (more hyperrules>).

more hyperrules ("."+layout>):
    ".",
    layout (layout>),->;
more hyperrules (";"+layout+lhs+alternative+more hyperrules>):
    ";",
    layout (layout>),
    lhs option (lhs>),
    alternative (alternative>),
    more hyperrules (more hyperrules>).

lhs option (ndm+def+no pb+layout>):
  name display mix* (ndm>), !:=! * (def>),
     no good page break (no pb>), layout (layout>).

lhs (ndm+def+no pb+layout>):
  name display mix+ (ndm>), !:=! (def>),
     no good page break (no pb>), layout (layout>).

name display mix (r>):
   affix display (r>),->;
name display mix (ESC UDS>):
   glammar identifier (ESC UDS>).


name display mix* (ndm+ ndm star>):
   name display mix (ndm>) ,
   name display mix* (ndm star>) , ->;
name display mix* (empty>):
   .

name display mix+ (ndm+ ndm star>):
   name display mix (ndm>) ,
   name display mix* (ndm star>).

bold lhs (full index+ndm+def+layout>):
  linenum (line>),
  bold name display mix+ (ndm>, index>), !:=! (def>), layout (layout>),
  where (>"\index{"+index+ " "+line +"}", full index>).

ESC UDS :: @escape underscore.

escape underscore (eu>):
       ^!_! *  (id>),
       escape underscore tail (>id, eu>).

escape underscore tail (>id, id + "\_"+x>):
    "_", ^!! * (x>),->;
escape underscore tail (>id, id >):.

glammar index identifier (id>):
  !abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890+*\t !+(id>). 

bold name display mix (r>, empty>):
   affix display (r>),->;
#bold name display mix ("\K{"+INDEX+"}\index{"+INDEX+ line +"}">):
bold name display mix ("\K{"+ESC UDS+"}">, index>):
   ?glammar index identifier (index>),
   glammar identifier (ESC UDS>).

bold name display mix* (ndm+ ndm star>, l+ll>):
   bold name display mix (ndm>,l>) ,
   bold name display mix* (ndm star>,ll>) , ->;
bold name display mix* (empty>,empty>):
   .

bold name display mix+ (ndm+ ndm star>,l+ll>):
   bold name display mix (ndm>,l>) ,
   bold name display mix* (ndm star>, ll>).

alternative (members>):        members (members>),->;
alternative (empty>):    .

members (member+more members>):
    member (member>),
    more members (more members>).

more members (","+no pb+layout+members>):
    ",", no good page break (no pb>),
    layout (layout>),
    members (members>),->;
more members (empty>):    .

member (ndm>):
    name display mix+ (ndm>), ->;
member (optional not symbol +set+optional sequence symbol +affix1 display option>):
    optional not symbol (optional not symbol>),
    set (set>),
    optional sequence symbol (optional sequence symbol>),
    affix1 display option (affix1 display option>),->;
member ("|\>"+layout>):
    "->",
    layout (layout>),->;
member ("\T{}"+quote+string+quote+"\TE{}"+layout>):
    quote,
    any escaped but quote (string>),
    quote,
    layout (layout>),->;
member ("?"+layout+member>):
    "?",
    layout (layout>),
    member (member>).

affix display ("\D{}("+layout+affix es+")\DE{}"+layout2>):
    "(",
    layout (layout>),
    affix es (affix es>),
    ")",
    layout (layout2>).

affix display option (afx>):
    affix display (afx>),->;
affix display option (empty>):    .

affix es (affix +rest affix es>):
    affix (affix>),
    rest affix es (rest affix es>).

rest affix es (","+layout+affix es>):
    ",",
    layout (layout>),
    affix es (affix es>),->;
rest affix es (empty>):    .

affix ("\>"+layout+terms>):
    ">",
    layout (layout>),
    terms (terms>),->;
affix (terms+flow>):
    terms (terms>),
    flow option (flow>).

flow option ("\>"+layout>):
    ">",
    layout (layout>),->;
flow option (empty>):.

affix1 display option ("\D{}("+layout+term+"\>"+layout2+")\DE{}"+layout3>):
    "(",
    layout (layout>),
    term (term>),
    ">",
    layout (layout2>),
    ")",
    layout (layout3>),->;
affix1 display option (empty>):    .

more affix es (","+layout+affix es>):
    ",",
    layout (layout>),
    affix es (affix es>),->;
more affix es (empty>):    .

rest metarule ("::"+layout+terms+"."+layout2>):
    "::",
    layout (layout>),
    terms (terms>),
    ".",
    layout (layout2>),->;
rest metarule ("::"+layout+"."+layout2>):
    "::",
    layout (layout>),
    ".",
    layout (layout2>),->;
rest metarule ("::"+layout+number+"."+layout2>):
    "::",
    layout (layout>),
    !-+0123456789! + (number>),  layout (_>),
    ".",
    layout (layout2>),->;
rest metarule ("::"+layout+"@@"+layout2+glammar identifier +
                   affix1 display option +"."+layout3>):
    "::",
    layout (layout>),
    "@",
    layout (layout2>),
    glammar identifier (glammar identifier>),
    affix1 display option (affix1 display option>),
    ".",
    layout (layout3>),->;
rest metarule ("::"+layout+"\{\}"+layout2+affix identifier list+ "."+layout3>):
    "::",
    layout (layout>),
    "{}",
    layout (layout2>),
    affix identifier list (affix identifier list>),
    ".",
    layout (layout3>).

terms (term+rest terms>):
    term (term>),
    rest terms (rest terms>).

rest terms ("+"+layout+terms>):
    "+",
    layout (layout>),
    terms (terms>),->;
rest terms ("*"+layout+terms>):
    "*",
    layout (layout>),
    terms (terms>),->;
rest terms (empty>):    .

more terms (term+"+"+layout+terms>):
    term (term>),
    "+",
    layout (layout>),
    terms (terms>).

term (affix identifier>):  affix identifier (affix identifier>),->;
term ("\_"+layout>):  "_", layout (layout>),->;
term ("\S{}\\"+quote+string+"\\"+quote+"\SE{}"+layout>):
    quote ,
    any escaped but quote (string>),
    quote ,
    layout (layout>).

optional not symbol ("\^"+layout>):
    "^",
    layout (layout>),->;
optional not symbol (empty>):    .

optional sequence symbol ("+"+layout>):
    "+",
    layout (layout>),->;
optional sequence symbol ("*"+layout>):
    "*",
    layout (layout>),->;
optional sequence symbol (empty>):    .

affix identifier list (affix identifier +";"+layout
                           +affix identifier list>):
   affix identifier (affix identifier>),
   ";", layout (layout>),
   affix identifier list (affix identifier list>),->;
affix identifier list (affix identifier>):
   affix identifier (affix identifier>).

affix identifier (identifier + layout + rest identifier>):
    identifier (identifier>),
    layout (layout>),
    rest affix identifier (rest identifier>).

rest affix identifier (numbers+rest>):
    !0123456789\n\t ! + (numbers>),
    rest identifier (rest>),->;
rest affix identifier (affix identifier>):
   affix identifier (affix identifier>), ->;
rest affix identifier (empty>):    .


glammar identifier (identifier + r+layout + rest identifier>):
    identifier (identifier>), ! *+?! *(r>),
    layout (layout>),
    rest identifier (rest identifier>).

rest identifier (numbers+rest>):
    !0123456789\n\t ! + (numbers>),
    rest identifier (rest>),->;
rest identifier (glammar identifier>):
   glammar identifier (glammar identifier>), ->;
rest identifier (empty>):    .

set ("!\T{}"+set1+"\TE{}!"+layout>):
    "!",
    any escaped but exclamation sign (set1>),
    "!",
    layout (layout>).

layout (x+rest layout>):
     ! ! * (x>),
    rest layout (rest layout>).

rest layout ("}}\n\L{\LB{"+layout>):
    "\n",->,layout (layout>),->;
rest layout ("}\Tab{"+n+"}{"+layout>):
    !\t!+ (t>), charnum (n>),->,layout (layout>),->;
rest layout ("\C{}\#"+x+"\CE{}"+layout>):
    "#", any escaped but new line (x>),
    rest layout (layout>),->;
rest layout ("}}\n\end{glammar}}\n"+x+"{\small\n\\begin{glammar}\n\L{\LB{"+layout>):
    "%TEX", ^!%!*(x>),
    "%",
    layout (layout>),->;
rest layout (x+"{\small\n\\begin{glammar}\n\L{\LB{"+layout>):
    "%^TEX", ^!%!*(x>),
    "%",
    layout (layout>),->;
rest layout ("}}\n\end{glammar}}"+x>):
    "%$TEX", ^!%!*(x>),
    "%",
    layout (layout>),->;
rest layout ("\C{}\%"+x+"\%\CE{}"+layout>):
    "%", any escaped but percent sign (x>),
    "%",
    layout (layout>),->;
rest layout (empty>):    .

any escaped but percent sign (any+rest>):
   ^!%|#"<>_$^~-/'&\{}\n! *(any>), more any escaped but percent sign (rest>).

more any escaped but percent sign (empty>): ?"%",->;
more any escaped but percent sign ("}}\n\L{\LB{"+rest>):
   "\n" ,  any escaped but percent sign (rest>),->;
more any escaped but percent sign ("\!"+rest>):
   "\\" ,  any escaped but percent sign (rest>),->;
more any escaped but percent sign ("\\"+any+rest>):
   !#"|<>_$~-'^&/{}! (any>),  any escaped but percent sign (rest>).

any escaped but quote (any+rest>):
   ^!%|#"<>~-'/_$^&{\}! *(any>), more any escaped but quote (rest>).

more any escaped but quote ("\!\""+rest>):
     "\\\"", any escaped but quote (rest>),->;
more any escaped but quote ("\!\!"+rest>):
   "\\\\" ,  any escaped but quote (rest>),->;
more any escaped but quote ("\!"+rest>):
   "\\" ,  any escaped but quote (rest>),->;
more any escaped but quote (empty>): ?"\"",->;
more any escaped but quote ("\\"+any+rest>):
   !%|#<>_~-'/$^&{}! (any>),  any escaped but quote (rest>).

any escaped but exclamation sign (any+rest>):
   ^!%#|\!<>~-'/"_$^&{\}! *(any>), more any escaped but exclamation sign (rest>).

more any escaped but exclamation sign ("\!!"+rest>):
     "\!", any escaped but exclamation sign (rest>),->;
more any escaped but exclamation sign ("\!"+rest>):
   "\\" ,  any escaped but exclamation sign (rest>),->;
more any escaped but exclamation sign (empty>): ?"!",->;
more any escaped but exclamation sign ("\\"+any+rest>):
   !%#|<>"~-'/_$^&{}! (any>),  any escaped but exclamation sign (rest>).

any escaped but new line (any+rest>):
   ^!%|<>#"\!~-'/_$^&{\}\n! *(any>), more any escaped but new line (rest>).

more any escaped but new line (empty>): ? "\n",->;
more any escaped but new line ("\!"+rest>):
   "\\" ,  any escaped but new line (rest>),->;
more any escaped but new line ("\\"+any+rest>):
   !%#|~-'/<>"\!_$^&{}! (any>),  any escaped but new line (rest>).

no good page break ("}}\n\\nopagebreak\n\L{\LB{">):
    "\n",->;
no good page break (empty>):.

options (o+oo>):
   option (o>),
   options (oo>),->;
options (empty>):.  

option ("\C{}\#"+x+"\CE{}}}\n\L{\LB{">): 
         "#", any escaped but new line (x>), nlcr.

plain glammar text( "{\small\n\\begin{glammar}\n\L{\LB{">, "}}\n\end{glammar}}\n">):
    try to find  option plain, ->;
plain glammar text (empty>, empty>):.

try to find  option plain: 
    get next option (opt>), more try find (>opt).

more try find (>"-plain"): ->;
more try find (>opt):
    try to find  option plain.
   
STUFF:: "%^TEX\n\
\documentstyle[glammar]{article}\n\
\\topmargin      0 mm\n\
\headheight     0 mm\n\
\headsep        0 mm\n\
\\textheight     240 mm\n\
\\footskip       7 mm\n\
\\footheight     11 mm\n\
\n\
\oddsidemargin  0 mm\n\
\evensidemargin 0 mm\n\
\\textwidth      159.2 mm\n\
\\author{Eric Voss}\n\
\\title{glammar to \LaTeX transducer}\n\
\makeindex\n\
\\begin{document}\n\
\maketitle\n\
%\n\
\n\
%$TEX\n\
\input{\jobname.ind}\n\
\end{document}\n\
%\n".

%$TEX
\input{\jobname.ind}
\end{document}
%

