/*

    This file is a part of the GLASS source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  S.J. Klaver, R Doesborg
              email: simon@sagan.nl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/*-----------------------------------------------------------------------
   File: checkglue.c
   Date: 18-10-1989
   Author: R. Doesborg
   Contents: procedures which check the consistency of the description
             of menus and parameter menus. The following checks
             are performed:
             - all types of default values should be correct;
             - if a menu refers to menu 'n', then menu 'n' should
               exist;
             - 
     Furthermore:
             - a procedure which returns a pointer to a menu, given the id
               of that menu;
             - a procedure which adds the item "Exit" to the main menu,
               unless this item was already specified.
-------------------------------------------------------------------------*/

#include <stdio.h>
#include <tmc.h>
#include "menuds.h"
#include "tools.h"
#include "globalvars.h"

extern char *malloc();
extern char *strcpy();
extern char *strcat();

/*
    add_exit adds the item "Exit" to the main menu, provided this item does
    not yet exist. It may fail to do so if there already exists an item
    in the main menu which has 'x' as identifying character and is not
    "Exit" (for example "Editor").
*/
int add_exit (gl)
  gluefile gl;
{
  Menu mainmenu;
  menuitemspec newitem;
  Do act;
  int it;
  int err = 0;
  actionspec_list newlist;

  mainmenu = find_menu(gl, mainmenuid);
  it = find_item(mainmenu, 'x');
  if (it == -1) {
    act = (Do)malloc(sizeof(*act));
    act->tag = TAGDo;
    act->actionno = -1;
    newlist = new_actionspec_list();
    newitem = new_menuitemspec("Exit", 0, 'x', 2, newlist);
    app_actionspec_list(newitem->action, (actionspec)act);
    app_menuitemspec_list(mainmenu->menuitems, newitem);
  }
  else
    err = (strcmp(mainmenu->menuitems->arr[it]->itemname, "Exit") != 0);
  return(err);
}

/* type_correct checks the type of a string:
   Boolean ==> str = "TRUE" or str = "FALSE";
   Integer ==> str = [-](0123456789)*;
   Real    ==> str = [-](0123456789)*[.(0123456789)*][E[-](0123456789)*];
   Enum    ==> str in strlist (which is found in the type specification);
   String  ==> true
*/
int type_correct (str, typ)
  string str;
  typespec typ;
{
  int correct;
  int ind;
  string_list slist;
  char *hstr;

  hstr = converttouppercase(str);
  switch (typ->tag) {
    case TAGBoolean:
      correct = (strcmp(hstr, "TRUE") == 0 || strcmp(hstr, "FALSE") == 0);
      break;
    case TAGInteger:
      if (*hstr == '-') hstr++;
      correct = 1;
      while (correct && *hstr != '\0') {
        correct = (*hstr >= '0' && *hstr <= '9');
        hstr++;
      }
      break;
    case TAGString:
      correct = 1;
      break;
    case TAGReal:
      if (*hstr == '-') hstr++;
      while (*hstr == ' ') hstr++;
      correct = (*hstr>='0' && *hstr <= '9');
      while (*hstr>='0' && *hstr <= '9') hstr++;
      if (*hstr == '.') {
        hstr++;
        while (*hstr>='0' && *hstr<='9') hstr++;
      }
      if (*hstr == 'E') {
        hstr++;
        if (*hstr == '-') hstr++;
        while (*hstr >= '0' && *hstr <= '9') hstr++;
      }
      correct = correct && (*hstr == '\0');
      break;
    case TAGEnum:
      slist = ((Enum)typ)->enumvals;
      for (ind = 0, correct = 0; !correct && ind < slist->sz; ind++)
        correct = (strcmp(hstr, slist->arr[ind]) == 0);
      break;
  }
  return(correct);
}

/* Performs some checks on the data structure: it checks whether
   references to other menus really exist, and it checks the type
   correctness of the default values in parameter sets.
   Furthermore, it adds the item 'EXIT' to the main menu.
   On errors, the function returns 1, 0 otherwise.

   If mainparid != 0 there are no menus in the data structure.
*/
int check_glueds (gl, mainparid)
  gluefile gl;
  int mainparid;
{
  menparspec_list mpsp;
  menuitemspec_list mlist;
  paritemspec_list plist;
  int i, j, id;
  Menu mn;
  int err = 0;
  int loc_err;
/*
  mpsp = ((Glue)gl) -> specs;
  for (i=0; i<mpsp->sz; i++)
    if ((mpsp->arr[i])->tag == TAGMenu) {
      mlist = ((Menu)mpsp->arr[i])->menuitems;
      for (j=0; j<mlist->sz; j++) {
        if ((mlist->arr[j])->tag == TAGShow) {
          id = ((Show)mlist->arr[j]->action)->menuid;
          mn = find_menu(gl, id);
          if (mn == NULL)
            printf("\nGLUE-E, Menu %d used, but not defined", id);
          err = err || (mn == NULL);
        }
      }
    }
    else {
      plist = ((Parset)mpsp->arr[i])->parsetitem;
      for (j=0; j<plist->sz; j++) {
        if (plist->arr[j]->partype->tag == TAGEnum)
          convertlisttouppercase(((Enum)plist->arr[j]->partype)->enumvals);
        loc_err = !type_correct(plist->arr[j]->pardefault,
                                plist->arr[j]->partype);
        if (loc_err)
          printf("GLUE-E, Default %s is not of the specified type\n",
                       plist->arr[j]->pardefault);
        err = err || loc_err;
      }
    }
*/
  if (mainparid == 0) err = err || add_exit(gl);
  return(err);
}

