
/*

    This file is a part of the GLASS source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  S.J. Klaver, R Doesborg
              email: simon@sagan.nl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include <stdio.h>
#include <tmc.h>
#include "menuds.h"

extern string malloc();

int uppercase (k)
  int k;
{
  if (k>='a' && k<='z')
    return(k - 'a' + 'A');
  else return(k);
}

string converttouppercase (str)
  string str;
{
  string hstr, loper;

  hstr = malloc(1+strlen(str));
  strcpy(hstr, str);
  for (loper = hstr; *loper != '\0'; loper++)
    *loper = uppercase(*loper);
  return(hstr);
}

void convertlisttouppercase (strl)
  string_list strl;
{
  int i;

  for (i=0; i<strl->sz; i++)
    strl->arr[i] = converttouppercase(strl->arr[i]);
}


/* Given an integer 'mnr', find_menu finds the record in the 
   data structure 'gl' with id 'mnr' and tag 'TAGMenu'.
*/
Menu find_menu (gl, mnr)
  gluefile gl;
  int mnr;
{
  menparspec_list l;
  int found;
  int ix;

  l = ((Glue)gl)->specs;
  found = 0;
  ix=0;
  while (ix<l->sz && !found)
  {
    if (l->arr[ix]->tag == TAGMenu)
       found = (((Menu)l->arr[ix])->menuid) == mnr;
    if (!found) ix++;
  }
  if (found)
    return((Menu)l->arr[ix]);
  else return((Menu)0);
}

int find_item (cm, key)
  Menu cm;
  int key;
{
  int walker;
  int found = 0;

  for (walker = 0; walker<cm->menuitems->sz && !found; walker++) {
    found = (uppercase(cm->menuitems->arr[walker]->idchar) == uppercase(key));
  }
  if (!found)
    return(-1);
  else return(walker-1);
}
