/* file: flagset.c */

#include "all.h"
#include "cvr.h"

/* Given a string 's' containing debug flags, a flag table 'flagtab' and
   a value 'val', look up all flags given in 's', and set the associated
   value to 'val'.
 */
void setdbflags( s, flagtab, val )
 char *s;
 dbflag *flagtab;
 int val;
{
    register int c;
    dbflag *e;

    while( *s != '\0' ){
	c = *s++;
	e = finddbflag( c, flagtab );
	if( e == dbflagNIL ){
	    fprintf( stderr, "Unknown debug flag: '%c'\n", c );
	    exit( 1 );
	}
	*e->flagadr = val;
    }
}
