/* File: testprog.c
 *
 * Test of library programs.
 */

/* Unix libraries */
#include <stdio.h>

int flaga;
int flagb;

/* the library to test */
#include "cvr.h"

dbflag flagtab[] =
{
    'a', &flaga, "flag a",
    'b', &flagb, "flag b",
    '\0', 0, ""
};

void bad( msg )
 char *msg;
{
   fprintf( stderr, "check error: %s\n", msg );
   exit( 1 );
}

int main()
{
   symbol a;
   symbol b;
   symbol t;
   symbol g1;
   symbol g2;
   char *m;

   initsymbol();
   a = addsymbol( "a" );
   b = addsymbol( "a" );
   if( a != b ){
       bad( "equal symbols do not compare equal" );
   }
   b = addsymbol( "b" );
   if( a == b ){
       bad( "unequal symbols compare equal" );
   }
   g1 = gensymbol( "base" );
   if( g1 == a || g1 == b ){
       bad( "gensym symbol is equal to existing symbol" );
   }
   t = findsymbol( "a" );
   if( t == symbolNIL ){
       bad( "symbol not found back" );
   }
   if( t != a ){
       bad( "wrong symbol found" );
   }
   t = findsymbol( "is not there" );
   if( t != symbolNIL ){
       fprintf( stderr, "symbol '%s'", symbolstr( t ) );
       bad( "non-existing symbol found" );
   }
   g2 = gensymbol( "base" );
   if( g2 == a || g2 == b || g2 == g1 ){
       bad( "gensym symbol is equal to existing symbol" );
   }
   m = ckmalloc( (unsigned int) 42 );
   m = ckrealloc( m, 100 );
   free( m );
   m = ckcalloc( (unsigned int) 42, (unsigned int) 42 );
   helpdbflags( stdout, flagtab );
   setdbflags( "ab", flagtab, 0 );
   if( flaga || flagb ){
       bad( "one flag still set" );
   }
   setdbflags( "b", flagtab, 1 );
   if( !flagb ){
       bad( "flag not set" );
   }
   setdbflags( "b", flagtab, 0 );
   if( flagb ){
       bad( "flag not reset" );
   }
   setdbflags( "a", flagtab, 1 );
   if( flagb ){
       bad( "wrong flag set" );
   }
   exit( 0 );
   return( 0 );
}
