/* 
   Copyright (C) 1990 C van Reewijk, email: dutentb.uucp!reeuwijk

This file is part of GLASS.

GLASS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GLASS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GLASS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* File: fscstr.c
 * 
 * Handle 'fscan_<type>' for type 'string'.
 */

/* Standard libraries */
#include <ctype.h>
#include <stdio.h>

/* Header of the library this code is part of. */
#include "tmc.h"
#include "config.h"

#define TRUE 1
#define FALSE 0
typedef short int bool;

/* Try to read a string in the buffer 'buf'. Give an error
   message if this is not successful. A string may contain
   escape sequences with a '\', but no newlines. The '"'
   around the string are stripped.
 */
int fscan_string( f, s )
 FILE *f;
 char **s;
{
    register int c;
    register bool done;
    char buf[STRBUFSZ];
    register char *bufp;
    register int brac;

    *s = (char *)0;
    bufp = buf;
    brac = fscanopenbrac( f );
    c = fgetc( f );
    if( c != '"' ){
	(void) strcpy( tmerrmsg, "string expected" );
	return( 1 );
    }
    done = FALSE;
    while( !done ){
	c = fgetc( f );
	if( c == '\n' ){
	    (void) strcpy( tmerrmsg, "newline in string" );
	    return( 1 );
	}
	if( c == '"' ) done = TRUE;
	if( c == '\\' ){
	    c = fgetc( f );
	    switch( c ){
		case 'b': c = '\b'; break;
		case 'f': c = '\f'; break;
		case 'n': c = '\n'; break;
		case 'r': c = '\r'; break;
		case 't': c = '\t'; break;
		case 'v': c = '\v'; break;
		default:
		    if( isdigit( c ) ){
			int val;

			val = c-'0';
			c = fgetc( f );
			if( isdigit( c ) ){
			    val = val*8 + (c-'0');
			    c = fgetc( f );
			    if( isdigit( c ) ){
				val = val*8 + (c-'0');
			    }
			    else
				ungetc( c, f );
			}
			else
			    ungetc( c, f );
			c = val;
		    }
		    break;
	    }
	}
	if( !done ) *bufp++ = c;
    }
    *bufp = '\0';
    *s = new_string( buf );
    return( fscanclosebrac( f, brac ) );
}
