/* 
   Copyright (C) 1990 C van Reewijk, email: dutentb.uucp!reeuwijk

This file is part of GLASS.

GLASS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GLASS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GLASS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* file: tmc.h
 *
 * declaration of routines in tm library.
 */

#ifndef _TM_TMCDEFS
#if defined( __STDC__ ) && __STDC__>0
/* print optimizer */
extern void setprint( FILE *f, int istep, int width );
extern void openlist( void );
extern void closelist( void );
extern void opencons( void );
extern void closecons( void );
extern void opentuple( void );
extern void closetuple( void );
extern void printword( char *w );

/* 'double' functions */
#define rdup_double(d) (d)
#define fre_double(d)
#define rfre_double(d)
extern int fscan_double( FILE *f, double *d );
extern void print_double( double d );
extern void fprint_double( FILE *f, double d );
extern int cmp_double( double a, double b );
#define doubleNIL (0.0)

/* 'int' functions */
#define rdup_int(i) (i)
#define fre_int(i)
#define rfre_int(i)
extern int fscan_int( FILE *f, int *i );
extern void print_int( int i );
extern void fprint_int( FILE *f, int i );
#define cmp_int(a,b) ((a)-(b))
#define intNIL (0)

/* 'unsigned' functions */
#define rdup_unsigned(i) (i)
#define fre_unsigned(i)
#define rfre_unsigned(i)
extern int fscan_unsigned( FILE *f, unsigned int *p );
extern void print_unsigned( unsigned int u );
extern void fprint_unsigned( FILE *f, unsigned int u );
#define cmp_unsigned(a,b) ((a)-(b))
#define unsignedNIL (0)

/* 'string' functions */
typedef char *string;
extern string new_string( char *s );
#define rdup_string(s) new_string(s)
extern void fre_string( string s );
#define rfre_string(s) fre_string(s)
extern int fscan_string( FILE *f, string *p );
extern void print_string( string );
extern void fprint_string( FILE *f, string s );
#define cmp_string(a,b) strcmp(a,b)
#define stringNIL ((char *)0)
extern void stat_string( FILE *f );

/* General scanning functions */
extern int fscanopenbrac( FILE *f );
extern int fscanclosebrac( FILE *f, int n );
extern int tmfneedc( FILE *f, int c );
extern int fscancons( FILE *f, char *s );
extern int fscanspace( FILE *f );

extern void tmfatal( char *file, int line, char *s );
#else
/* print optimizer */
extern void setprint();
extern void openlist();
extern void closelist();
extern void opencons();
extern void closecons();
extern void opentuple();
extern void closetuple();
extern void printword();

/* 'double' functions */
#define rdup_double(d) (d)
#define fre_double(d)
#define rfre_double(d)
extern int fscan_double();
extern void print_double();
extern void fprint_double();
extern int cmp_double();
#define doubleNIL (0.0)

/* 'int' functions */
#define rdup_int(i) (i)
#define fre_int(i)
#define rfre_int(i)
extern int fscan_int();
extern void print_int();
extern void fprint_int();
#define cmp_int(a,b) ((a)-(b))
#define intNIL (0)

/* 'unsigned' functions */
#define rdup_unsigned(i) (i)
#define fre_unsigned(i)
#define rfre_unsigned(i)
extern int fscan_unsigned();
extern void print_unsigned();
extern void fprint_unsigned();
#define cmp_unsigned(a,b) ((a)-(b))
#define unsignedNIL (0)

/* 'string' functions */
typedef char *string;
extern char *new_string();
#define rdup_string(s) new_string(s)
extern void fre_string();
#define rfre_string(s) fre_string(s)
extern int fscan_string();
extern void print_string();
extern void fprint_string();
#define cmp_string(a,b) strcmp(a,b)
#define stringNIL ((char *)0)
extern void stat_string();

/* 'tmbool' functions */
#define TMTRUESTR "True"
#define TMFALSESTR "False"
#ifdef orion
/* Orion C compiler gets upset by use of enumerated type as boolean. */
typedef short int tmbool;
#define TMFALSE (0)
#define TMTRUE (1)
#else
typedef enum en_tmbool { TMFALSE=0, TMTRUE=1 } tmbool;
#endif
#define new_tmbool(b) ((b)?TMTRUE:TMFALSE)
#define rdup_tmbool(b) (b)
#define fre_tmbool(b)
#define rfre_tmbool(b)
extern int fscan_tmbool();
#define print_tmbool(b) printword((b)?TMTRUESTR:TMFALSESTR)
#define fprint_tmbool(f,b) fputs(((b)?TMTRUESTR:TMFALSESTR),f)
#define cmp_tmbool(a,b) ((int)a-(int)b)
#define tmboolNIL TMFALSE

/* General scanning functions */
extern int fscanopenbrac();
extern int fscanclosebrac();
extern int tmfneedc();
extern int fscancons();
extern int fscanspace();

extern void tmfatal();
extern void tmbadtag();
#endif

/* the error message buffer of tm and its length */
extern char tmerrmsg[];
#define TMERRLEN 100
extern int tmlineno;

#define _TM_TMCDEFS 1
#endif
