/* 
   Copyright (C) 1990 C van Reewijk, email: dutentb.uucp!reeuwijk

This file is part of GLASS.

GLASS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GLASS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GLASS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* file: debug.c
   variables and routines for debugging.
 */

/* UNIX libraries */
#include <stdio.h>

/* Local definitions */
#include "debug.h"

#define TRUE 1
#define FALSE 0

extern FILE *tracestream;

/* Switch on debugging flags given by the string 's'.
   The flags are given in the table 'flagtab'.
 */
void setdbflags( s, flagtab )
 char *s;
 struct flagadrinfo *flagtab;
{
    register int c;
    struct flagadrinfo *p;
    register short int match;

    while( *s != '\0' ){
	c = *s++;
	p = flagtab;
	match = FALSE;
	while( p->flagchar != '\0' && match == FALSE ){
	    if( p->flagchar == c ){
		*p->flagadr = TRUE;
		match = TRUE;
	    }
	    p++;
	}
	if( match == FALSE ){
	    fprintf( stderr, "Unknown flag: '%c'\n", c );
	    exit( 1 );
	}
    }
}

/* Give help information on debugging flags. */
void dbhelp( flagtab )
 struct flagadrinfo *flagtab;
{
    struct flagadrinfo *p;

    fprintf( stdout, "Debugging flags:\n" );
    p = flagtab;
    while( p->flagchar != '\0' ){
	fprintf( stdout, " %c - %s.\n", p->flagchar, p->flagname );
	p++;
    }
}

/* For all flags that are set report that fact to 'tracestream'. */
void dbreport( flagtab )
 register struct flagadrinfo *flagtab;
{
    struct flagadrinfo *p;

    p = flagtab;
    while( p->flagchar != '\0' ){
	if( *p->flagadr ) fprintf( tracestream, "%s.\n", p->flagname );
	p++;
    }
}
